/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.io.InputStream;
import org.jboss.as.clustering.jgroups.subsystem.AbstractTransportResourceDefinitionRegistrar;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemResourceDefinitionRegistrar;
import org.jboss.as.clustering.jgroups.subsystem.OperationTestCaseBase;
import org.jboss.as.clustering.jgroups.subsystem.SocketProtocolResourceDefinitionRegistrar;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.dmr.ModelNode;
import org.junit.Assert;
import org.junit.Test;

public class OperationsTestCase
extends OperationTestCaseBase {
    @Test
    public void testSubsystemReadWriteOperations() throws Exception {
        KernelServices services = this.buildKernelServices();
        ModelNode result = services.executeOperation(OperationsTestCase.getSubsystemReadOperation((AttributeDefinition)JGroupsSubsystemResourceDefinitionRegistrar.DEFAULT_CHANNEL), new InputStream[0]);
        Assert.assertEquals((String)result.get("failure-description").asString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"ee", (Object)result.get("result").asString());
        result = services.executeOperation(OperationsTestCase.getSubsystemWriteOperation((AttributeDefinition)JGroupsSubsystemResourceDefinitionRegistrar.DEFAULT_CHANNEL, "bridge"), new InputStream[0]);
        Assert.assertEquals((String)result.get("failure-description").asString(), (Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(OperationsTestCase.getSubsystemReadOperation((AttributeDefinition)JGroupsSubsystemResourceDefinitionRegistrar.DEFAULT_CHANNEL), new InputStream[0]);
        Assert.assertEquals((String)result.get("failure-description").asString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"bridge", (Object)result.get("result").asString());
    }

    @Test
    public void testTransportReadWriteOperation() throws Exception {
        KernelServices services = this.buildKernelServices();
        ModelNode result = services.executeOperation(OperationsTestCase.getTransportReadOperation("maximal", "TCP", AbstractTransportResourceDefinitionRegistrar.TopologyAttribute.RACK.get()), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"rack1", (Object)ExpressionResolver.TEST_RESOLVER.resolveExpressions(result.get("result")).asString());
        result = services.executeOperation(OperationsTestCase.getTransportWriteOperation("maximal", "TCP", AbstractTransportResourceDefinitionRegistrar.TopologyAttribute.RACK.get(), "new-rack"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(OperationsTestCase.getTransportReadOperation("maximal", "TCP", AbstractTransportResourceDefinitionRegistrar.TopologyAttribute.RACK.get()), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"new-rack", (Object)result.get("result").asString());
    }

    @Test
    public void testTransportReadWriteWithParameters() throws Exception {
        KernelServices services = this.buildKernelServices();
        Assert.assertTrue((String)"Could not create services", (boolean)services.isSuccessfulBoot());
        ModelNode result = services.executeOperation(OperationsTestCase.getProtocolStackAddOperationWithParameters("maximal2"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(OperationsTestCase.getTransportWriteOperation("maximal", "TCP", AbstractTransportResourceDefinitionRegistrar.TopologyAttribute.RACK.get(), "new-rack"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(OperationsTestCase.getTransportReadOperation("maximal", "TCP", AbstractTransportResourceDefinitionRegistrar.TopologyAttribute.RACK.get()), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"new-rack", (Object)result.get("result").asString());
    }

    @Test
    public void testTransportPropertyReadWriteOperation() throws Exception {
        KernelServices services = this.buildKernelServices();
        ModelNode result = services.executeOperation(OperationsTestCase.getTransportGetPropertyOperation("maximal", "TCP", "enable_bundling"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"true", (Object)ExpressionResolver.TEST_RESOLVER.resolveExpressions(result.get("result")).asString());
        result = services.executeOperation(OperationsTestCase.getTransportPutPropertyOperation("maximal", "TCP", "enable_bundling", "false"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(OperationsTestCase.getTransportGetPropertyOperation("maximal", "TCP", "enable_bundling"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"false", (Object)result.get("result").asString());
        result = services.executeOperation(OperationsTestCase.getTransportRemovePropertyOperation("maximal", "TCP", "enable_bundling"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(OperationsTestCase.getTransportGetPropertyOperation("maximal", "TCP", "enable_bundling"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertFalse((boolean)result.get("result").isDefined());
    }

    @Test
    public void testProtocolReadWriteOperation() throws Exception {
        KernelServices services = this.buildKernelServices();
        ModelNode result = services.executeOperation(OperationsTestCase.getProtocolStackAddOperationWithParameters("maximal2"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(OperationsTestCase.getProtocolReadOperation("maximal", "MPING", SocketProtocolResourceDefinitionRegistrar.SocketBindingAttribute.SERVER.get()), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"jgroups-mping", (Object)result.get("result").asString());
        result = services.executeOperation(OperationsTestCase.getProtocolWriteOperation("maximal", "MPING", SocketProtocolResourceDefinitionRegistrar.SocketBindingAttribute.SERVER.get(), "new-socket-binding"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(OperationsTestCase.getProtocolReadOperation("maximal", "MPING", SocketProtocolResourceDefinitionRegistrar.SocketBindingAttribute.SERVER.get()), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"new-socket-binding", (Object)result.get("result").asString());
    }

    @Test
    public void testProtocolPropertyReadWriteOperation() throws Exception {
        KernelServices services = this.buildKernelServices();
        ModelNode result = services.executeOperation(OperationsTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "name"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"value", (Object)ExpressionResolver.TEST_RESOLVER.resolveExpressions(result.get("result")).asString());
        result = services.executeOperation(OperationsTestCase.getProtocolPutPropertyOperation("maximal", "MPING", "name", "new-value"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(OperationsTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "name"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"new-value", (Object)result.get("result").asString());
        result = services.executeOperation(OperationsTestCase.getProtocolRemovePropertyOperation("maximal", "MPING", "name"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(OperationsTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "name"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertFalse((boolean)result.get("result").isDefined());
    }

    @Test
    public void testLegacyProtocolAddRemoveOperation() throws Exception {
        KernelServices services = this.buildKernelServices();
        OperationsTestCase.testProtocolAddRemoveOperation(services, "MERGE2");
        OperationsTestCase.testProtocolAddRemoveOperation(services, "pbcast.NAKACK");
        OperationsTestCase.testProtocolAddRemoveOperation(services, "UNICAST2");
    }

    private static void testProtocolAddRemoveOperation(KernelServices services, String protocol) {
        ModelNode result = services.executeOperation(OperationsTestCase.getProtocolAddOperation("minimal", protocol), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(OperationsTestCase.getProtocolRemoveOperation("minimal", protocol), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
    }
}

