/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.clustering.jgroups.ProtocolPropertiesRepository;
import org.jboss.as.clustering.jgroups.logging.JGroupsLogger;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolChildResourceDefinitionRegistrar;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.RequirementServiceBuilder;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jgroups.stack.Protocol;
import org.jgroups.util.StackType;
import org.jgroups.util.Util;
import org.wildfly.clustering.jgroups.spi.ChannelFactoryConfiguration;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.ResourceModelResolver;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public abstract class ProtocolConfigurationResourceDefinitionRegistrar<P extends Protocol, C extends ProtocolConfiguration<P>>
extends ProtocolChildResourceDefinitionRegistrar
implements ResourceServiceConfigurator,
ResourceModelResolver<ServiceDependency<C>> {
    ResourceModelResolver<ServiceDependency<ProtocolConfiguration<P>>> resolver = new ResourceModelResolver<ServiceDependency<ProtocolConfiguration<P>>>(){

        public ServiceDependency<ProtocolConfiguration<P>> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
            final String name = context.getCurrentAddressValue();
            final ServiceDependency module = ProtocolChildResourceDefinitionRegistrar.MODULE.resolve(context, model);
            final Map properties = ProtocolChildResourceDefinitionRegistrar.PROPERTIES.resolve(context, model);
            final Boolean statisticsEnabled = ProtocolChildResourceDefinitionRegistrar.STATISTICS_ENABLED.resolve(context, model);
            final ServiceDependency repository = ServiceDependency.on(ProtocolPropertiesRepository.SERVICE_DESCRIPTOR);
            return new ServiceDependency<ProtocolConfiguration<P>>(){

                public void accept(RequirementServiceBuilder<?> builder) {
                    module.accept(builder);
                    repository.accept(builder);
                }

                public ProtocolConfiguration<P> get() {
                    return new ProtocolConfiguration<P>(){

                        public String getName() {
                            return name;
                        }

                        public P createProtocol(ChannelFactoryConfiguration configuration) {
                            try {
                                boolean nativeProtocol = ((Module)module.get()).getName().equals(ProtocolChildResourceDefinitionRegistrar.MODULE.getDefaultValue().asString()) && !name.startsWith("org.jgroups.protocols.");
                                Object className = nativeProtocol ? "org.jgroups.protocols." + name : name;
                                final Class<Protocol> protocolClass = ((Module)module.get()).getClassLoader().loadClass((String)className).asSubclass(Protocol.class);
                                final HashMap<String, String> protocolProperties = new HashMap<String, String>(((ProtocolPropertiesRepository)repository.get()).getProperties(protocolClass));
                                protocolProperties.putAll(properties);
                                PrivilegedExceptionAction<Protocol> action = new PrivilegedExceptionAction<Protocol>(){

                                    @Override
                                    public Protocol run() throws Exception {
                                        try {
                                            Protocol protocol = (Protocol)protocolClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                                            HashMap copy = new HashMap(protocolProperties);
                                            StackType type = Util.getIpStackType();
                                            org.jgroups.stack.Configurator.resolveAndAssignFields((Object)protocol, copy, (StackType)type);
                                            org.jgroups.stack.Configurator.resolveAndInvokePropertyMethods((Object)protocol, copy, (StackType)type);
                                            List objects = protocol.getComponents();
                                            if (objects != null) {
                                                for (Object object : objects) {
                                                    org.jgroups.stack.Configurator.resolveAndAssignFields(object, copy, (StackType)type);
                                                    org.jgroups.stack.Configurator.resolveAndInvokePropertyMethods(object, copy, (StackType)type);
                                                }
                                            }
                                            if (!copy.isEmpty()) {
                                                for (String property : copy.keySet()) {
                                                    JGroupsLogger.ROOT_LOGGER.unrecognizedProtocolProperty(name, property);
                                                }
                                            }
                                            return protocol;
                                        }
                                        catch (IllegalAccessException | InstantiationException e) {
                                            throw new IllegalStateException(e);
                                        }
                                    }
                                };
                                Protocol protocol = (Protocol)WildFlySecurityManager.doUnchecked((PrivilegedExceptionAction)action);
                                protocol.enableStats(statisticsEnabled != null ? statisticsEnabled.booleanValue() : configuration.isStatisticsEnabled());
                                return protocol;
                            }
                            catch (Exception e) {
                                throw new IllegalArgumentException(e);
                            }
                        }
                    };
                }
            };
        }
    };
    private final RuntimeCapability<Void> capability;
    private final ResourceOperationRuntimeHandler parentRuntimeHandler;

    ProtocolConfigurationResourceDefinitionRegistrar(Configurator configurator) {
        super(configurator);
        this.capability = configurator.getCapability();
        this.parentRuntimeHandler = configurator.getParentRuntimeHandler();
    }

    @Override
    public ResourceDescriptor.Builder apply(ResourceDescriptor.Builder builder) {
        return (ResourceDescriptor.Builder)((ResourceDescriptor.Builder)super.apply(builder).addCapability(this.capability)).withRuntimeHandler(ResourceOperationRuntimeHandler.combine((ResourceOperationRuntimeHandler[])new ResourceOperationRuntimeHandler[]{ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)this), ResourceOperationRuntimeHandler.restartParent((ResourceOperationRuntimeHandler)this.parentRuntimeHandler)}));
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        return (ResourceServiceInstaller)((CapabilityServiceInstaller.Builder)CapabilityServiceInstaller.builder(this.capability, (ServiceDependency)((ServiceDependency)this.resolve(context, model))).blocking()).build();
    }

    static interface Configurator
    extends ProtocolChildResourceDefinitionRegistrar.Configurator {
        public RuntimeCapability<Void> getCapability();

        public ResourceOperationRuntimeHandler getParentRuntimeHandler();
    }

    static class ProtocolConfigurationDecorator<P extends Protocol>
    implements ProtocolConfiguration<P> {
        private final ProtocolConfiguration<P> configuration;

        ProtocolConfigurationDecorator(ProtocolConfiguration<P> configuration) {
            this.configuration = configuration;
        }

        public String getName() {
            return this.configuration.getName();
        }

        public P createProtocol(ChannelFactoryConfiguration configuration) {
            return (P)this.configuration.createProtocol(configuration);
        }

        public Map<String, SocketBinding> getSocketBindings() {
            return this.configuration.getSocketBindings();
        }

        P setValue(P protocol, String propertyName, Object propertyValue) {
            PrivilegedAction action = new PrivilegedAction<P>((Protocol)protocol, propertyName, propertyValue){
                final /* synthetic */ Protocol val$protocol;
                final /* synthetic */ String val$propertyName;
                final /* synthetic */ Object val$propertyValue;
                {
                    this.val$protocol = protocol;
                    this.val$propertyName = string;
                    this.val$propertyValue = object;
                }

                @Override
                public P run() {
                    return this.val$protocol.setValue(this.val$propertyName, this.val$propertyValue);
                }
            };
            return (P)((Protocol)WildFlySecurityManager.doUnchecked((PrivilegedAction)action));
        }
    }
}

