/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.clustering.jgroups.logging.JGroupsLogger;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jgroups.JChannel;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.Property;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;
import org.wildfly.clustering.jgroups.spi.JGroupsServiceDescriptor;
import org.wildfly.common.function.ExceptionFunction;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.wildfly.service.capture.FunctionExecutor;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capture.FunctionExecutorRegistry;

public class ProtocolMetricsHandler
extends AbstractRuntimeOnlyHandler {
    private final FunctionExecutorRegistry<JChannel> executors;

    public ProtocolMetricsHandler(FunctionExecutorRegistry<JChannel> executors) {
        this.executors = executors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        final String name = operation.get("name").asString();
        final String protocolName = context.getCurrentAddressValue();
        ExceptionFunction<JChannel, ModelNode, Exception> function = new ExceptionFunction<JChannel, ModelNode, Exception>(){

            public ModelNode apply(JChannel channel) throws Exception {
                int index = protocolName.lastIndexOf(46);
                Protocol protocol = channel.getProtocolStack().findProtocol(index < 0 ? protocolName : protocolName.substring(index + 1));
                if (protocol == null) {
                    throw new IllegalArgumentException(protocolName);
                }
                Attribute attribute = ProtocolMetricsHandler.getAttribute(protocol.getClass(), name);
                if (attribute == null) {
                    throw new OperationFailedException(JGroupsLogger.ROOT_LOGGER.unknownMetric(name));
                }
                FieldType type = FieldType.valueOf(attribute.getType());
                ModelNode result = new ModelNode();
                Object value = attribute.read(protocol);
                if (value != null) {
                    type.setValue(result, value);
                }
                return result;
            }
        };
        FunctionExecutor executor = this.executors.getExecutor((Object)ServiceDependency.on((UnaryServiceDescriptor)JGroupsServiceDescriptor.CHANNEL, (String)context.getCurrentAddress().getParent().getLastElement().getValue()));
        try {
            ModelNode value;
            ModelNode modelNode = value = executor != null ? (ModelNode)executor.execute((ExceptionFunction)function) : null;
            if (value != null) {
                context.getResult().set(value);
            }
        }
        catch (Exception e) {
            context.getFailureDescription().set(e.getLocalizedMessage());
        }
        finally {
            context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
        }
    }

    static Attribute getAttribute(Class<? extends Protocol> targetClass, String name) {
        Map<String, Attribute> attributes = ProtocolMetricsHandler.findProtocolAttributes(targetClass);
        return attributes.get(name);
    }

    static Map<String, Attribute> findProtocolAttributes(Class<? extends Protocol> protocolClass) {
        HashMap<String, Attribute> attributes = new HashMap<String, Attribute>();
        Class<? extends Protocol> targetClass = protocolClass;
        while (Protocol.class.isAssignableFrom(targetClass)) {
            for (Method method : targetClass.getDeclaredMethods()) {
                if (method.getParameterCount() != 0 || !ProtocolMetricsHandler.isManagedAttribute(method)) continue;
                ProtocolMetricsHandler.putIfAbsent(attributes, new MethodAttribute(method));
            }
            for (AccessibleObject accessibleObject : targetClass.getDeclaredFields()) {
                if (!ProtocolMetricsHandler.isManagedAttribute(accessibleObject)) continue;
                ProtocolMetricsHandler.putIfAbsent(attributes, new FieldAttribute((Field)accessibleObject));
            }
            targetClass = targetClass.getSuperclass();
        }
        return attributes;
    }

    private static void putIfAbsent(Map<String, Attribute> attributes, Attribute attribute) {
        String name = attribute.getName().replace('.', '-');
        if (!attributes.containsKey(name)) {
            attributes.put(name, attribute);
        }
    }

    private static boolean isManagedAttribute(AccessibleObject object) {
        return object.isAnnotationPresent(ManagedAttribute.class) || object.isAnnotationPresent(Property.class) && object.getAnnotation(Property.class).exposeAsManagedAttribute();
    }

    static interface Attribute {
        public String getName();

        public String getDescription();

        public Class<?> getType();

        public Object read(Object var1) throws Exception;
    }

    static class MethodAttribute
    extends AbstractAttribute<Method> {
        MethodAttribute(Method method) {
            super(method);
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name != null ? name : Util.methodNameToAttributeName((String)((Method)this.accessible).getName());
        }

        @Override
        public Class<?> getType() {
            return ((Method)this.accessible).getReturnType();
        }

        @Override
        Object get(Object object) throws IllegalAccessException, InvocationTargetException {
            return ((Method)this.accessible).invoke(object, new Object[0]);
        }
    }

    static class FieldAttribute
    extends AbstractAttribute<Field> {
        FieldAttribute(Field field) {
            super(field);
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name != null ? name : ((Field)this.accessible).getName();
        }

        @Override
        public Class<?> getType() {
            return ((Field)this.accessible).getType();
        }

        @Override
        Object get(Object object) throws IllegalAccessException {
            return ((Field)this.accessible).get(object);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum FieldType {
        BOOLEAN(ModelType.BOOLEAN, new Class[]{Boolean.TYPE, Boolean.class}){

            @Override
            void setValue(ModelNode node, Object value) {
                node.set(((Boolean)value).booleanValue());
            }
        }
        ,
        INT(ModelType.INT, new Class[]{Integer.TYPE, Integer.class, Byte.TYPE, Byte.class, Short.TYPE, Short.class}){

            @Override
            void setValue(ModelNode node, Object value) {
                node.set(((Number)value).intValue());
            }
        }
        ,
        LONG(ModelType.LONG, new Class[]{Long.TYPE, Long.class}){

            @Override
            void setValue(ModelNode node, Object value) {
                node.set(((Long)value).longValue());
            }
        }
        ,
        DOUBLE(ModelType.DOUBLE, new Class[]{Double.TYPE, Double.class, Float.TYPE, Float.class}){

            @Override
            void setValue(ModelNode node, Object value) {
                node.set(((Number)value).doubleValue());
            }
        }
        ,
        STRING(ModelType.STRING, new Class[0]){

            @Override
            void setValue(ModelNode node, Object value) {
                node.set(value.toString());
            }
        };

        private static final Map<Class<?>, FieldType> TYPES;
        private final Class<?>[] types;
        private final ModelType modelType;

        private FieldType(ModelType modelType, Class<?> ... types) {
            this.modelType = modelType;
            this.types = types;
        }

        abstract void setValue(ModelNode var1, Object var2);

        public ModelType getModelType() {
            return this.modelType;
        }

        public static FieldType valueOf(Class<?> typeClass) {
            FieldType type = TYPES.get(typeClass);
            return type != null ? type : STRING;
        }

        static {
            TYPES = new HashMap();
            for (FieldType type : FieldType.values()) {
                for (Class<?> classType : type.types) {
                    TYPES.put(classType, type);
                }
            }
        }
    }

    static abstract class AbstractAttribute<A extends AccessibleObject>
    implements Attribute {
        final A accessible;

        AbstractAttribute(A accessible) {
            this.accessible = accessible;
        }

        @Override
        public String getName() {
            String name;
            if (((AccessibleObject)this.accessible).isAnnotationPresent(ManagedAttribute.class) && !(name = ((AccessibleObject)this.accessible).getAnnotation(ManagedAttribute.class).name()).isEmpty()) {
                return name;
            }
            if (((AccessibleObject)this.accessible).isAnnotationPresent(Property.class) && !(name = ((AccessibleObject)this.accessible).getAnnotation(Property.class).name()).isEmpty()) {
                return name;
            }
            return null;
        }

        @Override
        public String getDescription() {
            if (((AccessibleObject)this.accessible).isAnnotationPresent(ManagedAttribute.class)) {
                return ((AccessibleObject)this.accessible).getAnnotation(ManagedAttribute.class).description();
            }
            if (((AccessibleObject)this.accessible).isAnnotationPresent(Property.class)) {
                return ((AccessibleObject)this.accessible).getAnnotation(Property.class).description();
            }
            return this.accessible.toString();
        }

        @Override
        public Object read(final Object object) throws Exception {
            PrivilegedExceptionAction<Object> action = new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    ((AccessibleObject)accessible).setAccessible(true);
                    try {
                        Object object2 = this.get(object);
                        return object2;
                    }
                    finally {
                        ((AccessibleObject)accessible).setAccessible(false);
                    }
                }
            };
            try {
                return WildFlySecurityManager.doUnchecked((PrivilegedExceptionAction)action);
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        }

        abstract Object get(Object var1) throws Exception;
    }
}

