/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.function.BiConsumer;
import org.junit.Assert;
import org.wildfly.clustering.marshalling.Externalizer;

public class ExternalizerTester<T> {
    private final Externalizer<T> externalizer;
    private final BiConsumer<T, T> assertion;

    public ExternalizerTester(Externalizer<T> externalizer) {
        this(externalizer, Assert::assertEquals);
    }

    public ExternalizerTester(Externalizer<T> externalizer, BiConsumer<T, T> assertion) {
        this.externalizer = externalizer;
        this.assertion = assertion;
    }

    public void test(T subject) throws IOException, ClassNotFoundException {
        Assert.assertTrue((boolean)this.externalizer.getTargetClass().isInstance(subject));
        ByteArrayOutputStream externalizedOutput = new ByteArrayOutputStream();
        try (ObjectOutputStream output = new ObjectOutputStream(externalizedOutput);){
            this.externalizer.writeObject((ObjectOutput)output, subject);
        }
        byte[] externalizedBytes = externalizedOutput.toByteArray();
        try (ObjectInputStream input = new ObjectInputStream(new ByteArrayInputStream(externalizedBytes));){
            Object result = this.externalizer.readObject((ObjectInput)input);
            Assert.assertTrue((boolean)this.externalizer.getTargetClass().isInstance(result));
            this.assertion.accept(subject, result);
        }
        if (subject instanceof Serializable) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try (ObjectOutputStream output = new ObjectOutputStream(out);){
                output.writeObject(subject);
            }
            byte[] bytes = out.toByteArray();
            Assert.assertTrue((externalizedBytes.length < bytes.length ? 1 : 0) != 0);
        }
    }
}

