/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import org.wildfly.clustering.marshalling.TestMarshaller;

public class SerializationTestMarshaller<T>
implements TestMarshaller<T> {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T read(ByteBuffer buffer) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(buffer.array(), buffer.arrayOffset(), buffer.limit() - buffer.arrayOffset());
        try (ObjectInputStream input = new ObjectInputStream(in);){
            Object object = input.readObject();
            return (T)object;
        }
        catch (ClassNotFoundException e) {
            InvalidClassException exception = new InvalidClassException(e.getMessage());
            exception.initCause(e);
            throw exception;
        }
    }

    @Override
    public ByteBuffer write(T object) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (ObjectOutputStream output = new ObjectOutputStream(out);){
            output.writeObject(object);
        }
        return ByteBuffer.wrap(out.toByteArray());
    }
}

