/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.clustering.marshalling.MarshallingTester;
import org.wildfly.clustering.marshalling.MarshallingTesterFactory;
import org.wildfly.clustering.marshalling.Person;

public abstract class AbstractCircularReferenceTestCase {
    private final MarshallingTesterFactory factory;

    public AbstractCircularReferenceTestCase(MarshallingTesterFactory factory) {
        this.factory = factory;
    }

    @Test
    public void test() throws IOException {
        Person parent = Person.create("parent");
        Person self = Person.create("self");
        parent.addChild(self);
        parent.addChild(Person.create("sibling"));
        self.addChild(Person.create("son"));
        self.addChild(Person.create("daughter"));
        MarshallingTester<Person> tester = this.factory.createTester();
        tester.test(self, (expected, actual) -> {
            Assert.assertEquals((Object)expected, (Object)actual);
            Assert.assertEquals((Object)expected.getParent(), (Object)actual.getParent());
            Assert.assertEquals(expected.getChildren(), actual.getChildren());
            for (Person child : actual.getParent().getChildren()) {
                Assert.assertSame((Object)actual.getParent(), (Object)child.getParent());
            }
            for (Person child : actual.getChildren()) {
                Assert.assertSame((Object)actual, (Object)child.getParent());
            }
        });
    }
}

