/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.jboss;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.Map;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Unmarshaller;
import org.wildfly.clustering.marshalling.spi.IndexSerializer;
import org.wildfly.clustering.marshalling.spi.IntSerializer;

public class SimpleClassTable
implements ClassTable {
    private final Class<?>[] classes;
    private final Map<Class<?>, ClassTable.Writer> writers = new IdentityHashMap();
    private final IntSerializer indexSerializer;

    public SimpleClassTable(Class<?> ... classes) {
        this(IndexSerializer.select((int)classes.length), classes);
    }

    private SimpleClassTable(final IntSerializer indexSerializer, Class<?> ... classes) {
        this.indexSerializer = indexSerializer;
        this.classes = classes;
        for (int i = 0; i < classes.length; ++i) {
            final int index = i;
            ClassTable.Writer writer = new ClassTable.Writer(){

                public void writeClass(Marshaller output, Class<?> clazz) throws IOException {
                    indexSerializer.writeInt((DataOutput)output, index);
                }
            };
            this.writers.put(classes[i], writer);
        }
    }

    public ClassTable.Writer getClassWriter(Class<?> clazz) {
        return this.writers.get(clazz);
    }

    public Class<?> readClass(Unmarshaller input) throws IOException, ClassNotFoundException {
        return this.classes[this.indexSerializer.readInt((DataInput)input)];
    }
}

