/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.jboss;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.OptionalInt;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ObjectTable;
import org.wildfly.clustering.marshalling.jboss.DynamicClassTable;
import org.wildfly.clustering.marshalling.jboss.ExternalizerObjectTable;
import org.wildfly.clustering.marshalling.jboss.JBossByteBufferMarshaller;
import org.wildfly.clustering.marshalling.jboss.MarshallingConfigurationRepository;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshaller;

public enum TestJBossByteBufferMarshaller implements MarshallingConfigurationRepository,
ByteBufferMarshaller
{
    INSTANCE;

    private final MarshallingConfiguration configuration;
    private final ByteBufferMarshaller marshaller;

    private TestJBossByteBufferMarshaller() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        this.configuration = new MarshallingConfiguration();
        this.configuration.setClassTable((ClassTable)new DynamicClassTable(new ClassLoader[]{loader}));
        this.configuration.setObjectTable((ObjectTable)new ExternalizerObjectTable(new ClassLoader[]{loader}));
        this.marshaller = new JBossByteBufferMarshaller((MarshallingConfigurationRepository)this, loader);
    }

    public boolean isMarshallable(Object object) {
        return this.marshaller.isMarshallable(object);
    }

    public Object readFrom(InputStream input) throws IOException {
        return this.marshaller.readFrom(input);
    }

    public void writeTo(OutputStream output, Object object) throws IOException {
        this.marshaller.writeTo(output, object);
    }

    public OptionalInt size(Object object) {
        return this.marshaller.size(object);
    }

    public int getCurrentMarshallingVersion() {
        return 0;
    }

    public MarshallingConfiguration getMarshallingConfiguration(int version) {
        return this.configuration;
    }
}

