/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Map;
import org.wildfly.clustering.marshalling.Externalizer;

public class SingletonMapExternalizer
implements Externalizer<Map<Object, Object>> {
    public void writeObject(ObjectOutput output, Map<Object, Object> map) throws IOException {
        Map.Entry entry = (Map.Entry)map.entrySet().stream().findFirst().get();
        output.writeObject(entry.getKey());
        output.writeObject(entry.getValue());
    }

    public Map<Object, Object> readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        return Collections.singletonMap(input.readObject(), input.readObject());
    }

    public Class<Map<Object, Object>> getTargetClass() {
        return Collections.singletonMap(null, null).getClass();
    }
}

