/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi.time;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.time.Instant;
import java.util.OptionalInt;
import org.wildfly.clustering.marshalling.Externalizer;

public class InstantExternalizer
implements Externalizer<Instant> {
    public void writeObject(ObjectOutput output, Instant instant) throws IOException {
        output.writeLong(instant.getEpochSecond());
        output.writeInt(instant.getNano());
    }

    public Instant readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        long seconds = input.readLong();
        int nanos = input.readInt();
        return Instant.ofEpochSecond(seconds, nanos);
    }

    public Class<Instant> getTargetClass() {
        return Instant.class;
    }

    public OptionalInt size(Instant object) {
        return OptionalInt.of(12);
    }
}

