/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi.util;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.wildfly.clustering.marshalling.spi.BooleanExternalizer;
import org.wildfly.clustering.marshalling.spi.util.HashSetExternalizer;
import org.wildfly.clustering.marshalling.spi.util.MapExternalizer;

public class LinkedHashMapExternalizer
extends MapExternalizer<LinkedHashMap<Object, Object>, Boolean, Map.Entry<Boolean, Integer>> {
    public static final Function<Map.Entry<Boolean, Integer>, LinkedHashMap<Object, Object>> FACTORY = new Function<Map.Entry<Boolean, Integer>, LinkedHashMap<Object, Object>>(){

        @Override
        public LinkedHashMap<Object, Object> apply(Map.Entry<Boolean, Integer> entry) {
            int size = entry.getValue();
            int capacity = HashSetExternalizer.CAPACITY.applyAsInt(size);
            return new LinkedHashMap<Object, Object>(capacity, 0.75f, entry.getKey());
        }
    };
    public static final Function<LinkedHashMap<Object, Object>, Boolean> ACCESS_ORDER = new Function<LinkedHashMap<Object, Object>, Boolean>(){

        @Override
        public Boolean apply(LinkedHashMap<Object, Object> map) {
            Object insertOrder = new Object();
            Object accessOrder = new Object();
            map.put(insertOrder, null);
            map.put(accessOrder, null);
            map.get(insertOrder);
            Iterator<Object> keys = map.keySet().iterator();
            Object element = keys.next();
            while (element != insertOrder && element != accessOrder) {
                element = keys.next();
            }
            map.remove(insertOrder);
            map.remove(accessOrder);
            return element == accessOrder;
        }
    };

    public LinkedHashMapExternalizer() {
        super(LinkedHashMap.class, FACTORY, Function.identity(), ACCESS_ORDER, new BooleanExternalizer<Boolean>(Boolean.class, Function.identity(), Function.identity()));
    }
}

