/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshalledValue;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshalledValueFactory;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.spi.JavaByteBufferMarshaller;

public class ByteBufferMarshalledValueFactoryTestCase {
    private final ByteBufferMarshaller marshaller;
    private final ByteBufferMarshalledValueFactory factory;

    public ByteBufferMarshalledValueFactoryTestCase() {
        this(JavaByteBufferMarshaller.INSTANCE);
    }

    protected ByteBufferMarshalledValueFactoryTestCase(ByteBufferMarshaller marshaller) {
        this(marshaller, new ByteBufferMarshalledValueFactory(marshaller));
    }

    ByteBufferMarshalledValueFactoryTestCase(ByteBufferMarshaller marshaller, ByteBufferMarshalledValueFactory factory) {
        this.marshaller = marshaller;
        this.factory = factory;
    }

    @Test
    public void get() throws Exception {
        UUID uuid = UUID.randomUUID();
        ByteBufferMarshalledValue mv = this.factory.createMarshalledValue((Object)uuid);
        Assert.assertNotNull((Object)mv.peek());
        Assert.assertSame((Object)uuid, (Object)mv.peek());
        Assert.assertSame((Object)uuid, (Object)mv.get(this.marshaller));
        ByteBufferMarshalledValue copy = this.replicate(mv);
        Assert.assertNull((Object)copy.peek());
        UUID uuid2 = (UUID)copy.get(this.marshaller);
        Assert.assertNotSame((Object)uuid, (Object)uuid2);
        Assert.assertEquals((Object)uuid, (Object)uuid2);
        copy = this.replicate(copy);
        uuid2 = (UUID)copy.get(this.marshaller);
        Assert.assertEquals((Object)uuid, (Object)uuid2);
        mv = this.factory.createMarshalledValue(null);
        Assert.assertNull((Object)mv.peek());
        Assert.assertNull((Object)mv.getBuffer());
        Assert.assertNull((Object)mv.get(this.marshaller));
    }

    @Test
    public void equals() throws Exception {
        UUID uuid = UUID.randomUUID();
        ByteBufferMarshalledValue mv = this.factory.createMarshalledValue((Object)uuid);
        Assert.assertTrue((boolean)mv.equals((Object)mv));
        Assert.assertFalse((boolean)mv.equals(null));
        ByteBufferMarshalledValue dup = this.factory.createMarshalledValue((Object)uuid);
        Assert.assertTrue((boolean)mv.equals((Object)dup));
        Assert.assertTrue((boolean)dup.equals((Object)mv));
        ByteBufferMarshalledValue replica = this.replicate(mv);
        Assert.assertTrue((boolean)mv.equals(replica));
        Assert.assertTrue((boolean)replica.equals((Object)mv));
        ByteBufferMarshalledValue nulled = this.factory.createMarshalledValue(null);
        Assert.assertFalse((boolean)mv.equals((Object)nulled));
        Assert.assertFalse((boolean)nulled.equals((Object)mv));
        Assert.assertFalse((boolean)replica.equals((Object)nulled));
        Assert.assertFalse((boolean)nulled.equals(replica));
        Assert.assertTrue((boolean)nulled.equals((Object)nulled));
        Assert.assertFalse((boolean)nulled.equals(null));
        Assert.assertTrue((boolean)nulled.equals((Object)this.factory.createMarshalledValue(null)));
    }

    @Test
    public void testHashCode() throws Exception {
        UUID uuid = UUID.randomUUID();
        ByteBufferMarshalledValue mv = this.factory.createMarshalledValue((Object)uuid);
        Assert.assertEquals((long)uuid.hashCode(), (long)mv.hashCode());
        ByteBufferMarshalledValue copy = this.replicate(mv);
        Assert.assertEquals((long)0L, (long)copy.hashCode());
        mv = this.factory.createMarshalledValue(null);
        Assert.assertEquals((long)0L, (long)mv.hashCode());
    }

    <V> ByteBufferMarshalledValue<V> replicate(ByteBufferMarshalledValue<V> value) throws IOException {
        ByteBuffer buffer = this.marshaller.write(value);
        return (ByteBufferMarshalledValue)this.marshaller.read(buffer);
    }
}

