/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.OptionalInt;
import org.junit.Assert;
import org.wildfly.clustering.marshalling.TestMarshaller;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshaller;

public class ByteBufferTestMarshaller<T>
implements TestMarshaller<T> {
    private final ByteBufferMarshaller marshaller;

    public ByteBufferTestMarshaller(ByteBufferMarshaller marshaller) {
        this.marshaller = marshaller;
    }

    public T read(ByteBuffer buffer) throws IOException {
        return (T)this.marshaller.read(buffer);
    }

    public ByteBuffer write(T object) throws IOException {
        ByteBuffer buffer = this.marshaller.write(object);
        OptionalInt size = this.marshaller.size(object);
        if (size.isPresent()) {
            Assert.assertEquals((long)buffer.remaining(), (long)size.getAsInt());
        }
        return buffer;
    }
}

