/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.group;

import org.infinispan.Cache;
import org.jboss.as.clustering.infinispan.subsystem.CacheService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.server.group.CacheGroup;
import org.wildfly.clustering.server.group.CacheGroupConfiguration;
import org.wildfly.clustering.server.group.CacheNodeFactory;
import org.wildfly.clustering.spi.CacheServiceNames;

public class CacheGroupService
implements Service<Group>,
CacheGroupConfiguration {
    private final InjectedValue<Cache> cache = new InjectedValue();
    private final InjectedValue<CacheNodeFactory> factory = new InjectedValue();
    private volatile CacheGroup group;

    public static ServiceBuilder<Group> build(ServiceTarget target, ServiceName name, String containerName, String cacheName) {
        CacheGroupService service = new CacheGroupService();
        return target.addService(name, (Service)service).addDependency(CacheService.getServiceName((String)containerName, (String)cacheName), Cache.class, service.cache).addDependency(CacheServiceNames.NODE_FACTORY.getServiceName(containerName, cacheName), CacheNodeFactory.class, service.factory);
    }

    private CacheGroupService() {
    }

    public Group getValue() {
        return this.group;
    }

    public void start(StartContext context) {
        this.group = new CacheGroup(this);
    }

    public void stop(StopContext context) {
        this.group.close();
        this.group = null;
    }

    @Override
    public Cache<?, ?> getCache() {
        return (Cache)this.cache.getValue();
    }

    @Override
    public CacheNodeFactory getNodeFactory() {
        return (CacheNodeFactory)this.factory.getValue();
    }
}

