/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.provider;

import java.util.Set;
import org.infinispan.Cache;
import org.jboss.as.clustering.infinispan.subsystem.CacheService;
import org.jboss.as.clustering.msc.AsynchronousService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.infinispan.InfinispanBatcher;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.provider.ServiceProviderRegistrationFactory;
import org.wildfly.clustering.server.provider.CacheServiceProviderRegistrationFactory;
import org.wildfly.clustering.server.provider.CacheServiceProviderRegistrationFactoryConfiguration;
import org.wildfly.clustering.spi.CacheServiceNames;
import org.wildfly.clustering.spi.ChannelServiceNames;

public class CacheServiceProviderRegistrationFactoryService
implements Service<ServiceProviderRegistrationFactory>,
CacheServiceProviderRegistrationFactoryConfiguration {
    private final Object id;
    private final InjectedValue<CommandDispatcherFactory> dispatcherFactory = new InjectedValue();
    private final InjectedValue<Group> group = new InjectedValue();
    private final InjectedValue<Cache> cache = new InjectedValue();
    private volatile CacheServiceProviderRegistrationFactory factory = null;

    public static ServiceBuilder<ServiceProviderRegistrationFactory> build(ServiceTarget target, ServiceName name, String containerName, String cacheName) {
        CacheServiceProviderRegistrationFactoryService service = new CacheServiceProviderRegistrationFactoryService(name);
        return AsynchronousService.addService((ServiceTarget)target, (ServiceName)name, (Service)service).addDependency(CacheService.getServiceName((String)containerName, (String)cacheName), Cache.class, service.cache).addDependency(CacheServiceNames.GROUP.getServiceName(containerName, cacheName), Group.class, service.group).addDependency(ChannelServiceNames.COMMAND_DISPATCHER.getServiceName(containerName), CommandDispatcherFactory.class, service.dispatcherFactory);
    }

    private CacheServiceProviderRegistrationFactoryService(Object id) {
        this.id = id;
    }

    @Override
    public Object getId() {
        return this.id;
    }

    @Override
    public Group getGroup() {
        return (Group)this.group.getValue();
    }

    @Override
    public Cache<Object, Set<Node>> getCache() {
        return (Cache)this.cache.getValue();
    }

    @Override
    public CommandDispatcherFactory getCommandDispatcherFactory() {
        return (CommandDispatcherFactory)this.dispatcherFactory.getValue();
    }

    @Override
    public Batcher<? extends Batch> getBatcher() {
        return new InfinispanBatcher((Cache)this.cache.getValue());
    }

    public ServiceProviderRegistrationFactory getValue() {
        return this.factory;
    }

    public void start(StartContext context) {
        this.factory = new CacheServiceProviderRegistrationFactory(this);
    }

    public void stop(StopContext context) {
        this.factory.close();
        this.factory = null;
    }
}

