/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.registry;

import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.notifications.Listener;
import org.infinispan.remoting.transport.Address;
import org.jboss.as.clustering.infinispan.subsystem.CacheService;
import org.jboss.as.clustering.msc.AsynchronousService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.infinispan.InfinispanBatcher;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.group.NodeFactory;
import org.wildfly.clustering.registry.RegistryFactory;
import org.wildfly.clustering.server.group.CacheNodeFactory;
import org.wildfly.clustering.server.registry.CacheRegistryFactory;
import org.wildfly.clustering.server.registry.CacheRegistryFactoryConfiguration;
import org.wildfly.clustering.spi.CacheServiceNames;

@Listener
public class CacheRegistryFactoryService<K, V>
implements Service<RegistryFactory<K, V>>,
CacheRegistryFactoryConfiguration<K, V> {
    private final InjectedValue<Group> group = new InjectedValue();
    private final InjectedValue<Cache> cache = new InjectedValue();
    private final InjectedValue<CacheNodeFactory> factory = new InjectedValue();
    private volatile CacheRegistryFactory<K, V> value = null;

    public static <K, V> ServiceBuilder<RegistryFactory<K, V>> build(ServiceTarget target, ServiceName name, String containerName, String cacheName) {
        CacheRegistryFactoryService<K, V> service = new CacheRegistryFactoryService<K, V>();
        return AsynchronousService.addService((ServiceTarget)target, (ServiceName)name, service).addDependency(CacheServiceNames.NODE_FACTORY.getServiceName(containerName, cacheName), CacheNodeFactory.class, service.factory).addDependency(CacheServiceNames.GROUP.getServiceName(containerName, cacheName), Group.class, service.group).addDependency(CacheService.getServiceName((String)containerName, (String)cacheName), Cache.class, service.cache);
    }

    private CacheRegistryFactoryService() {
    }

    public RegistryFactory<K, V> getValue() {
        return this.value;
    }

    public void start(StartContext context) {
        this.value = new CacheRegistryFactory(this);
    }

    public void stop(StopContext context) {
        this.value = null;
    }

    @Override
    public Batcher<? extends Batch> getBatcher() {
        return new InfinispanBatcher((Cache)this.cache.getValue());
    }

    @Override
    public Group getGroup() {
        return (Group)this.group.getValue();
    }

    @Override
    public Cache<Node, Map.Entry<K, V>> getCache() {
        return (Cache)this.cache.getValue();
    }

    @Override
    public NodeFactory<Address> getNodeFactory() {
        return (NodeFactory)this.factory.getValue();
    }
}

