/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.singleton.election;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.singleton.election.SocketAddressPreference;

public class SocketAddressPreferenceTestCase {
    @Test
    public void test() throws UnknownHostException {
        InetSocketAddress preferredAddress = new InetSocketAddress(InetAddress.getByName("127.0.0.1"), 1);
        InetSocketAddress otherAddress1 = new InetSocketAddress(InetAddress.getByName("127.0.0.1"), 2);
        InetSocketAddress otherAddress2 = new InetSocketAddress(InetAddress.getByName("127.0.0.2"), 1);
        SocketAddressPreference preference = new SocketAddressPreference(preferredAddress);
        Node preferredNode = (Node)Mockito.mock(Node.class);
        Node otherNode1 = (Node)Mockito.mock(Node.class);
        Node otherNode2 = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)preferredNode.getSocketAddress()).thenReturn((Object)preferredAddress);
        Mockito.when((Object)otherNode1.getSocketAddress()).thenReturn((Object)otherAddress1);
        Mockito.when((Object)otherNode2.getSocketAddress()).thenReturn((Object)otherAddress2);
        Assert.assertTrue((boolean)preference.preferred(preferredNode));
        Assert.assertFalse((boolean)preference.preferred(otherNode1));
        Assert.assertFalse((boolean)preference.preferred(otherNode2));
    }
}

