/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.singleton.election;

import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.server.GroupMember;
import org.wildfly.clustering.singleton.election.SingletonElectionPolicy;

public class SingletonElectionPolicyTestCase {
    @Test
    public void test() {
        GroupMember member1 = (GroupMember)Mockito.mock(GroupMember.class);
        GroupMember member2 = (GroupMember)Mockito.mock(GroupMember.class);
        GroupMember member3 = (GroupMember)Mockito.mock(GroupMember.class);
        List<GroupMember> candidates = List.of(member1, member2, member3);
        Assert.assertSame((Object)member1, (Object)SingletonElectionPolicy.oldest().elect(candidates));
        Assert.assertSame((Object)member2, (Object)SingletonElectionPolicy.position((int)1).elect(candidates));
        Assert.assertSame((Object)member3, (Object)SingletonElectionPolicy.youngest().elect(candidates));
        Assert.assertNotNull((Object)SingletonElectionPolicy.random().elect(candidates));
        ((GroupMember)Mockito.doReturn((Object)"member1").when((Object)member1)).getName();
        ((GroupMember)Mockito.doReturn((Object)"member2").when((Object)member2)).getName();
        ((GroupMember)Mockito.doReturn((Object)"member3").when((Object)member3)).getName();
        Assert.assertSame((Object)member1, (Object)SingletonElectionPolicy.youngest().prefer(List.of(SingletonElectionPolicyTestCase.prefer("member1"))).elect(candidates));
        Assert.assertSame((Object)member1, (Object)SingletonElectionPolicy.youngest().prefer(List.of(SingletonElectionPolicyTestCase.prefer("member1"), SingletonElectionPolicyTestCase.prefer("member2"))).elect(candidates));
        Assert.assertSame((Object)member2, (Object)SingletonElectionPolicy.youngest().prefer(List.of(SingletonElectionPolicyTestCase.prefer(Set.of("member1", "member2")))).elect(candidates));
        Assert.assertSame((Object)member2, (Object)SingletonElectionPolicy.youngest().prefer(List.of(SingletonElectionPolicyTestCase.prefer(Set.of("member1", "member2")), SingletonElectionPolicyTestCase.prefer(Set.of("member2", "member3")))).elect(candidates));
        Assert.assertSame((Object)member3, (Object)SingletonElectionPolicy.youngest().prefer(List.of(SingletonElectionPolicyTestCase.prefer("member4"))).elect(candidates));
    }

    private static Predicate<GroupMember> prefer(String name) {
        return member -> name.equals(member.getName());
    }

    private static Predicate<GroupMember> prefer(Set<String> names) {
        return member -> names.contains(member.getName());
    }
}

