/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod.session;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.github.benmanes.caffeine.cache.Weigher;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.configuration.NearCacheConfiguration;
import org.infinispan.client.hotrod.near.NearCache;
import org.infinispan.client.hotrod.near.NearCacheFactory;
import org.wildfly.clustering.ee.hotrod.RemoteCacheKey;
import org.wildfly.clustering.infinispan.client.near.CaffeineNearCache;
import org.wildfly.clustering.infinispan.client.near.EvictionListener;
import org.wildfly.clustering.infinispan.client.near.SimpleKeyWeigher;
import org.wildfly.clustering.web.hotrod.session.SessionAccessMetaDataKey;
import org.wildfly.clustering.web.hotrod.session.SessionCreationMetaDataKey;
import org.wildfly.clustering.web.hotrod.session.coarse.SessionAttributesKey;
import org.wildfly.clustering.web.hotrod.session.fine.SessionAttributeKey;
import org.wildfly.clustering.web.hotrod.session.fine.SessionAttributeNamesKey;
import org.wildfly.clustering.web.session.SessionAttributePersistenceStrategy;

public class SessionManagerNearCacheFactory
implements NearCacheFactory {
    private final Integer maxActiveSessions;
    private final SessionAttributePersistenceStrategy strategy;

    public SessionManagerNearCacheFactory(Integer maxActiveSessions, SessionAttributePersistenceStrategy strategy) {
        this.maxActiveSessions = maxActiveSessions;
        this.strategy = strategy;
    }

    public <K, V> NearCache<K, V> createNearCache(NearCacheConfiguration config, BiConsumer<K, MetadataValue<V>> removedConsumer) {
        EvictionListener listener = this.maxActiveSessions != null ? new EvictionListener(removedConsumer, (BiConsumer)new InvalidationListener(this.strategy)) : null;
        Caffeine builder = Caffeine.newBuilder();
        if (listener != null) {
            builder.executor(Runnable::run).maximumWeight(this.maxActiveSessions.longValue()).weigher((Weigher)new SimpleKeyWeigher(SessionCreationMetaDataKey.class::isInstance)).removalListener((RemovalListener)listener);
        }
        Cache cache = builder.build();
        if (listener != null) {
            listener.accept(cache);
        }
        return new CaffeineNearCache(cache);
    }

    private static class InvalidationListener
    implements BiConsumer<Cache<Object, MetadataValue<Object>>, Map.Entry<Object, Object>> {
        private final SessionAttributePersistenceStrategy strategy;

        InvalidationListener(SessionAttributePersistenceStrategy strategy) {
            this.strategy = strategy;
        }

        @Override
        public void accept(Cache<Object, MetadataValue<Object>> cache, Map.Entry<Object, Object> entry) {
            Object key = entry.getKey();
            if (key instanceof SessionCreationMetaDataKey) {
                String id = (String)((SessionCreationMetaDataKey)((Object)key)).getId();
                LinkedList<RemoteCacheKey> keys = new LinkedList<RemoteCacheKey>();
                keys.add(new SessionAccessMetaDataKey(id));
                switch (this.strategy) {
                    case COARSE: {
                        keys.add(new SessionAttributesKey(id));
                        break;
                    }
                    case FINE: {
                        SessionAttributeNamesKey namesKey = new SessionAttributeNamesKey(id);
                        keys.add(namesKey);
                        MetadataValue namesValue = (MetadataValue)cache.getIfPresent((Object)namesKey);
                        if (namesValue == null) break;
                        Map names = (Map)namesValue.getValue();
                        for (UUID attributeId : names.values()) {
                            keys.add(new SessionAttributeKey(id, attributeId));
                        }
                        break;
                    }
                }
                cache.invalidateAll(keys);
            }
        }
    }
}

