/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session.fine;

import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.wildfly.clustering.ee.infinispan.CacheEntryMutator;
import org.wildfly.clustering.ee.infinispan.MutableCacheEntry;
import org.wildfly.clustering.ee.infinispan.Mutator;
import org.wildfly.clustering.marshalling.InvalidSerializedFormException;
import org.wildfly.clustering.marshalling.MarshalledValue;
import org.wildfly.clustering.marshalling.Marshaller;
import org.wildfly.clustering.marshalling.MarshallingContext;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.infinispan.logging.InfinispanWebLogger;
import org.wildfly.clustering.web.infinispan.session.InfinispanImmutableSession;
import org.wildfly.clustering.web.infinispan.session.InfinispanSession;
import org.wildfly.clustering.web.infinispan.session.SessionFactory;
import org.wildfly.clustering.web.infinispan.session.SimpleSessionMetaData;
import org.wildfly.clustering.web.infinispan.session.fine.FineImmutableSessionAttributes;
import org.wildfly.clustering.web.infinispan.session.fine.FineSessionAttributes;
import org.wildfly.clustering.web.infinispan.session.fine.FineSessionCacheEntry;
import org.wildfly.clustering.web.infinispan.session.fine.SessionAttributeCacheKey;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;
import org.wildfly.clustering.web.session.Session;
import org.wildfly.clustering.web.session.SessionContext;
import org.wildfly.clustering.web.session.SessionMetaData;

public class FineSessionFactory<L>
implements SessionFactory<MutableCacheEntry<FineSessionCacheEntry<L>>, L> {
    private final Cache<String, FineSessionCacheEntry<L>> sessionCache;
    private final Cache<SessionAttributeCacheKey, MarshalledValue<Object, MarshallingContext>> attributeCache;
    private final SessionContext context;
    private final Marshaller<Object, MarshalledValue<Object, MarshallingContext>> marshaller;
    private final LocalContextFactory<L> localContextFactory;

    public FineSessionFactory(Cache<String, FineSessionCacheEntry<L>> sessionCache, Cache<SessionAttributeCacheKey, MarshalledValue<Object, MarshallingContext>> attributeCache, SessionContext context, Marshaller<Object, MarshalledValue<Object, MarshallingContext>> marshaller, LocalContextFactory<L> localContextFactory) {
        this.sessionCache = sessionCache;
        this.attributeCache = attributeCache;
        this.context = context;
        this.marshaller = marshaller;
        this.localContextFactory = localContextFactory;
    }

    @Override
    public Session<L> createSession(String id, MutableCacheEntry<FineSessionCacheEntry<L>> entry) {
        FineSessionCacheEntry sessionEntry = (FineSessionCacheEntry)entry.getValue();
        SessionMetaData metaData = sessionEntry.getMetaData();
        FineSessionAttributes<MarshalledValue<Object, MarshallingContext>> attributes = new FineSessionAttributes<MarshalledValue<Object, MarshallingContext>>(id, this.attributeCache, this.marshaller);
        return new InfinispanSession(id, metaData, attributes, sessionEntry.getLocalContext(), this.localContextFactory, this.context, entry.getMutator(), this);
    }

    @Override
    public ImmutableSession createImmutableSession(String id, MutableCacheEntry<FineSessionCacheEntry<L>> entry) {
        FineImmutableSessionAttributes<MarshalledValue<Object, MarshallingContext>> attributes = new FineImmutableSessionAttributes<MarshalledValue<Object, MarshallingContext>>(id, this.attributeCache, this.marshaller);
        return new InfinispanImmutableSession(id, (ImmutableSessionMetaData)((FineSessionCacheEntry)entry.getValue()).getMetaData(), attributes, this.context);
    }

    public MutableCacheEntry<FineSessionCacheEntry<L>> findValue(String id) {
        FineSessionCacheEntry value = (FineSessionCacheEntry)this.sessionCache.get((Object)id);
        if (value == null) {
            return null;
        }
        for (Map.Entry entry : this.attributeCache.getAdvancedCache().getGroup(id).entrySet()) {
            try {
                this.marshaller.read(entry.getValue());
            }
            catch (InvalidSerializedFormException e) {
                InfinispanWebLogger.ROOT_LOGGER.failedToActivateSessionAttribute(e, id, ((SessionAttributeCacheKey)entry.getKey()).getAttribute());
                this.remove(id);
                return null;
            }
        }
        return new MutableCacheEntry((Object)value, (Mutator)new CacheEntryMutator(this.sessionCache, (Object)id, (Object)value));
    }

    public MutableCacheEntry<FineSessionCacheEntry<L>> createValue(String id, Void context) {
        FineSessionCacheEntry value = new FineSessionCacheEntry(new SimpleSessionMetaData());
        FineSessionCacheEntry existing = (FineSessionCacheEntry)this.sessionCache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).putIfAbsent((Object)id, value);
        if (existing == null) {
            return new MutableCacheEntry(value, Mutator.PASSIVE);
        }
        for (Map.Entry entry : this.attributeCache.getAdvancedCache().getGroup(id).entrySet()) {
            try {
                this.marshaller.read(entry.getValue());
            }
            catch (InvalidSerializedFormException e) {
                InfinispanWebLogger.ROOT_LOGGER.failedToActivateSessionAttribute(e, id, ((SessionAttributeCacheKey)entry.getKey()).getAttribute());
                this.remove(id);
                return this.createValue(id, context);
            }
        }
        return new MutableCacheEntry((Object)existing, (Mutator)new CacheEntryMutator(this.sessionCache, (Object)id, (Object)existing));
    }

    public void remove(String id) {
        this.sessionCache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).remove((Object)id);
        this.attributeCache.getAdvancedCache().removeGroup(id);
    }

    public void evict(String id) {
        for (SessionAttributeCacheKey key : this.attributeCache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD}).getGroup(id).keySet()) {
            try {
                this.attributeCache.evict((Object)key);
            }
            catch (Throwable e) {
                InfinispanWebLogger.ROOT_LOGGER.failedToPassivateSessionAttribute(e, id, key.getAttribute());
            }
        }
        try {
            this.sessionCache.evict((Object)id);
        }
        catch (Throwable e) {
            InfinispanWebLogger.ROOT_LOGGER.failedToPassivateSession(e, id);
        }
    }
}

