/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import org.infinispan.Cache;
import org.infinispan.remoting.transport.Address;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.infinispan.spi.InfinispanCacheRequirement;
import org.wildfly.clustering.registry.Registry;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ValueDependency;
import org.wildfly.clustering.spi.ClusteringCacheRequirement;
import org.wildfly.clustering.spi.NodeFactory;
import org.wildfly.clustering.web.infinispan.session.InfinispanRouteLocator;
import org.wildfly.clustering.web.infinispan.session.InfinispanRouteLocatorConfiguration;
import org.wildfly.clustering.web.session.RouteLocator;

public class InfinispanRouteLocatorBuilder
implements CapabilityServiceBuilder<RouteLocator>,
InfinispanRouteLocatorConfiguration,
Value<RouteLocator> {
    private final String containerName = "web";
    private final String serverName;
    private final String deploymentName;
    private volatile ValueDependency<NodeFactory> factory;
    private volatile ValueDependency<Registry> registry;
    private volatile ValueDependency<Cache> cache;

    public InfinispanRouteLocatorBuilder(String serverName, String deploymentName) {
        this.serverName = serverName;
        this.deploymentName = deploymentName;
    }

    public RouteLocator getValue() {
        return new InfinispanRouteLocator(this);
    }

    public ServiceName getServiceName() {
        return ServiceName.JBOSS.append(new String[]{"clustering", "web", "locator", this.deploymentName});
    }

    public Builder<RouteLocator> configure(CapabilityServiceSupport support) {
        this.factory = new InjectedValueDependency(ClusteringCacheRequirement.GROUP.getServiceName(support, this.containerName, this.serverName), NodeFactory.class);
        this.registry = new InjectedValueDependency(ClusteringCacheRequirement.REGISTRY.getServiceName(support, this.containerName, this.serverName), Registry.class);
        this.cache = new InjectedValueDependency(InfinispanCacheRequirement.CACHE.getServiceName(support, this.containerName, this.deploymentName), Cache.class);
        return this;
    }

    public ServiceBuilder<RouteLocator> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName(), (Service)new ValueService((Value)this)).setInitialMode(ServiceController.Mode.ON_DEMAND);
        return new CompositeDependency(new Dependency[]{this.factory, this.registry, this.cache}).register(builder);
    }

    @Override
    public Cache<String, ?> getCache() {
        return (Cache)this.cache.getValue();
    }

    @Override
    public Registry<String, Void> getRegistry() {
        return (Registry)this.registry.getValue();
    }

    @Override
    public NodeFactory<Address> getMemberFactory() {
        return (NodeFactory)this.factory.getValue();
    }
}

