/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.time.Duration;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.context.Flag;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryActivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryPassivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryActivatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryPassivatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.wildfly.clustering.Registrar;
import org.wildfly.clustering.Registration;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.Recordable;
import org.wildfly.clustering.ee.Scheduler;
import org.wildfly.clustering.ee.cache.CacheProperties;
import org.wildfly.clustering.ee.cache.tx.TransactionBatch;
import org.wildfly.clustering.infinispan.spi.PredicateKeyFilter;
import org.wildfly.clustering.infinispan.spi.distribution.CacheLocality;
import org.wildfly.clustering.infinispan.spi.distribution.Key;
import org.wildfly.clustering.infinispan.spi.distribution.Locality;
import org.wildfly.clustering.web.IdentifierFactory;
import org.wildfly.clustering.web.cache.session.ImmutableSessionActivationNotifier;
import org.wildfly.clustering.web.cache.session.ImmutableSessionBindingNotifier;
import org.wildfly.clustering.web.cache.session.SessionFactory;
import org.wildfly.clustering.web.cache.session.SimpleImmutableSession;
import org.wildfly.clustering.web.cache.session.ValidSession;
import org.wildfly.clustering.web.infinispan.logging.InfinispanWebLogger;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManagerConfiguration;
import org.wildfly.clustering.web.infinispan.session.SessionCreationMetaDataKey;
import org.wildfly.clustering.web.infinispan.session.SessionCreationMetaDataKeyFilter;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;
import org.wildfly.clustering.web.session.Session;
import org.wildfly.clustering.web.session.SessionExpirationListener;
import org.wildfly.clustering.web.session.SessionManager;
import org.wildfly.clustering.web.session.SpecificationProvider;

@Listener(primaryOnly=true)
public class InfinispanSessionManager<S, SC, AL, BL, MV, AV, LC>
implements SessionManager<LC, TransactionBatch> {
    private final Registrar<SessionExpirationListener> expirationRegistrar;
    private final SessionExpirationListener expirationListener;
    private final Batcher<TransactionBatch> batcher;
    private final Cache<Key<String>, ?> cache;
    private final CacheProperties properties;
    private final SessionFactory<SC, MV, AV, LC> factory;
    private final IdentifierFactory<String> identifierFactory;
    private final Scheduler<String, ImmutableSessionMetaData> expirationScheduler;
    private final Predicate<Object> filter = new SessionCreationMetaDataKeyFilter();
    private final Recordable<ImmutableSession> recorder;
    private final SC context;
    private final SpecificationProvider<S, SC, AL, BL> provider;
    private volatile Duration defaultMaxInactiveInterval = Duration.ofMinutes(30L);
    private volatile Registration expirationRegistration;

    public InfinispanSessionManager(SessionFactory<SC, MV, AV, LC> factory, InfinispanSessionManagerConfiguration<S, SC, AL, BL> configuration) {
        this.factory = factory;
        this.cache = configuration.getCache();
        this.properties = configuration.getProperties();
        this.expirationRegistrar = configuration.getExpirationRegistar();
        this.expirationListener = configuration.getExpirationListener();
        this.identifierFactory = configuration.getIdentifierFactory();
        this.batcher = configuration.getBatcher();
        this.expirationScheduler = configuration.getExpirationScheduler();
        this.recorder = configuration.getInactiveSessionRecorder();
        this.context = configuration.getServletContext();
        this.provider = configuration.getSpecificationProvider();
    }

    public void start() {
        if (this.recorder != null) {
            this.recorder.reset();
        }
        this.identifierFactory.start();
        this.expirationRegistration = this.expirationRegistrar.register((Object)this.expirationListener);
        PredicateKeyFilter filter = new PredicateKeyFilter(this.filter);
        this.cache.addListener((Object)this, (CacheEventFilter)filter, null);
        this.cache.addListener((Object)this.factory.getMetaDataFactory(), (CacheEventFilter)filter, null);
        this.cache.addListener((Object)this.factory.getAttributesFactory(), (CacheEventFilter)filter, null);
    }

    public void stop() {
        this.expirationRegistration.close();
        this.cache.removeListener((Object)this);
        this.cache.removeListener((Object)this.factory.getMetaDataFactory());
        this.cache.removeListener((Object)this.factory.getAttributesFactory());
        this.identifierFactory.stop();
    }

    public Duration getStopTimeout() {
        return Duration.ofMillis(this.cache.getCacheConfiguration().transaction().cacheStopTimeout());
    }

    public Batcher<TransactionBatch> getBatcher() {
        return this.batcher;
    }

    public Duration getDefaultMaxInactiveInterval() {
        return this.defaultMaxInactiveInterval;
    }

    public void setDefaultMaxInactiveInterval(Duration duration) {
        this.defaultMaxInactiveInterval = duration;
    }

    public String createIdentifier() {
        return (String)this.identifierFactory.createIdentifier();
    }

    public Session<LC> findSession(String id) {
        Map.Entry value = (Map.Entry)this.factory.findValue((Object)id);
        if (value == null) {
            InfinispanWebLogger.ROOT_LOGGER.tracef("Session %s not found", id);
            return null;
        }
        ImmutableSession session = this.factory.createImmutableSession(id, value);
        if (session.getMetaData().isExpired()) {
            InfinispanWebLogger.ROOT_LOGGER.tracef("Session %s was found, but has expired", id);
            this.expirationListener.sessionExpired(session);
            this.factory.remove((Object)id);
            return null;
        }
        this.expirationScheduler.cancel((Object)id);
        return new ValidSession(this.factory.createSession(id, value, this.context), this.expirationScheduler);
    }

    public Session<LC> createSession(String id) {
        Map.Entry entry = (Map.Entry)this.factory.createValue((Object)id, null);
        if (entry == null) {
            return null;
        }
        Session session = this.factory.createSession(id, entry, this.context);
        session.getMetaData().setMaxInactiveInterval(this.defaultMaxInactiveInterval);
        return new ValidSession(session, this.expirationScheduler);
    }

    public ImmutableSession viewSession(String id) {
        Map.Entry value = (Map.Entry)this.factory.findValue((Object)id);
        return value != null ? new SimpleImmutableSession(this.factory.createImmutableSession(id, value)) : null;
    }

    public Set<String> getActiveSessions() {
        return this.getSessions(Flag.CACHE_MODE_LOCAL, Flag.SKIP_CACHE_LOAD);
    }

    public Set<String> getLocalSessions() {
        return this.getSessions(Flag.CACHE_MODE_LOCAL);
    }

    private Set<String> getSessions(Flag ... flags) {
        CacheLocality locality = new CacheLocality(this.cache);
        try (CacheStream keys = this.cache.getAdvancedCache().withFlags(flags).keySet().stream();){
            Set<String> set = keys.filter(this.filter.and(arg_0 -> InfinispanSessionManager.lambda$getSessions$0((Locality)locality, arg_0))).map(key -> (String)key.getValue()).collect(Collectors.toSet());
            return set;
        }
    }

    public long getActiveSessionCount() {
        return this.getActiveSessions().size();
    }

    @CacheEntryActivated
    public void activated(CacheEntryActivatedEvent<SessionCreationMetaDataKey, ?> event) {
        if (!event.isPre() && !this.properties.isPersistent()) {
            String id = (String)((SessionCreationMetaDataKey)((Object)event.getKey())).getValue();
            InfinispanWebLogger.ROOT_LOGGER.tracef("Session %s was activated", id);
            Map.Entry value = (Map.Entry)this.factory.tryValue((Object)id);
            if (value != null) {
                ImmutableSession session = this.factory.createImmutableSession(id, value);
                new ImmutableSessionActivationNotifier(this.provider, session, this.context).postActivate();
            }
        }
    }

    @CacheEntryPassivated
    public void passivated(CacheEntryPassivatedEvent<SessionCreationMetaDataKey, ?> event) {
        if (event.isPre() && !this.properties.isPersistent()) {
            String id = (String)((SessionCreationMetaDataKey)((Object)event.getKey())).getValue();
            InfinispanWebLogger.ROOT_LOGGER.tracef("Session %s will be passivated", id);
            Map.Entry value = (Map.Entry)this.factory.tryValue((Object)id);
            if (value != null) {
                ImmutableSession session = this.factory.createImmutableSession(id, value);
                new ImmutableSessionActivationNotifier(this.provider, session, this.context).prePassivate();
            }
        }
    }

    @CacheEntryRemoved
    public void removed(CacheEntryRemovedEvent<SessionCreationMetaDataKey, ?> event) {
        if (event.isPre()) {
            String id = (String)((SessionCreationMetaDataKey)((Object)event.getKey())).getValue();
            InfinispanWebLogger.ROOT_LOGGER.tracef("Session %s will be removed", id);
            Map.Entry value = (Map.Entry)this.factory.tryValue((Object)id);
            if (value != null) {
                ImmutableSession session = this.factory.createImmutableSession(id, value);
                new ImmutableSessionBindingNotifier(this.provider, session, this.context).unbound();
                if (this.recorder != null) {
                    this.recorder.record((Object)session);
                }
            }
        }
    }

    private static /* synthetic */ boolean lambda$getSessions$0(Locality locality, Object key) {
        return locality.isLocal(key);
    }
}

