/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.util.Map;
import org.infinispan.Cache;
import org.jboss.as.clustering.MarshalledValueFactory;
import org.jboss.as.clustering.MarshallingContext;
import org.jboss.as.clustering.SimpleMarshalledValueFactory;
import org.jboss.as.clustering.VersionedMarshallingConfiguration;
import org.jboss.as.clustering.infinispan.affinity.KeyAffinityServiceFactory;
import org.jboss.as.clustering.infinispan.invoker.CacheInvoker;
import org.jboss.as.clustering.infinispan.invoker.RetryingCacheInvoker;
import org.jboss.as.clustering.registry.Registry;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.modules.Module;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.infinispan.InfinispanWebMessages;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManager;
import org.wildfly.clustering.web.infinispan.session.MarshalledValueSessionAttributeMarshaller;
import org.wildfly.clustering.web.infinispan.session.SessionAttributeMarshallingContext;
import org.wildfly.clustering.web.infinispan.session.SessionFactory;
import org.wildfly.clustering.web.infinispan.session.coarse.CoarseSessionFactory;
import org.wildfly.clustering.web.infinispan.session.fine.FineSessionFactory;
import org.wildfly.clustering.web.session.SessionContext;
import org.wildfly.clustering.web.session.SessionIdentifierFactory;
import org.wildfly.clustering.web.session.SessionManager;
import org.wildfly.clustering.web.session.SessionManagerFactory;

public class InfinispanSessionManagerFactory
extends AbstractService<SessionManagerFactory>
implements SessionManagerFactory {
    private final SessionAttributeMarshallingContext context;
    private final JBossWebMetaData metaData;
    private final CacheInvoker invoker = new RetryingCacheInvoker(new int[]{10, 100});
    private final Value<Cache> cache;
    private final Value<KeyAffinityServiceFactory> affinityFactory;
    private final Value<Registry> registry;

    public InfinispanSessionManagerFactory(Module module, JBossWebMetaData metaData, Value<Cache> cache, Value<KeyAffinityServiceFactory> affinityFactory, Value<Registry> registry) {
        this.context = new SessionAttributeMarshallingContext(module);
        this.cache = cache;
        this.affinityFactory = affinityFactory;
        this.registry = registry;
        this.metaData = metaData;
    }

    public SessionManagerFactory getValue() {
        return this;
    }

    public <L> SessionManager<L> createSessionManager(SessionContext context, SessionIdentifierFactory identifierFactory, LocalContextFactory<L> localContextFactory) {
        Cache cache = (Cache)this.cache.getValue();
        return new InfinispanSessionManager(context, identifierFactory, cache, this.getSessionFactory(context, localContextFactory, cache), (KeyAffinityServiceFactory)this.affinityFactory.getValue(), (Registry<String, Void>)((Registry)this.registry.getValue()), this.metaData);
    }

    private <L> SessionFactory<?, L> getSessionFactory(SessionContext context, LocalContextFactory<L> localContextFactory, Cache<?, ?> cache) {
        MarshallingContext marshallingContext = new MarshallingContext((VersionedMarshallingConfiguration)this.context);
        SimpleMarshalledValueFactory factory = new SimpleMarshalledValueFactory(marshallingContext);
        switch (this.metaData.getReplicationConfig().getReplicationGranularity()) {
            case ATTRIBUTE: {
                Cache<?, ?> sessionCache = cache;
                Cache<?, ?> attributeCache = cache;
                MarshalledValueSessionAttributeMarshaller<Object, MarshallingContext> marshaller = new MarshalledValueSessionAttributeMarshaller<Object, MarshallingContext>((MarshalledValueFactory<MarshallingContext>)factory, marshallingContext);
                return new FineSessionFactory<L>(sessionCache, attributeCache, this.invoker, context, marshaller, localContextFactory);
            }
            case SESSION: {
                Cache<?, ?> sessionCache = cache;
                Cache<?, ?> attributesCache = cache;
                MarshalledValueSessionAttributeMarshaller<Map<String, Object>, MarshallingContext> marshaller = new MarshalledValueSessionAttributeMarshaller<Map<String, Object>, MarshallingContext>((MarshalledValueFactory<MarshallingContext>)factory, marshallingContext);
                return new CoarseSessionFactory<L>(sessionCache, attributesCache, this.invoker, context, marshaller, localContextFactory);
            }
        }
        throw InfinispanWebMessages.MESSAGES.unknownReplicationGranularity(this.metaData.getReplicationConfig().getReplicationGranularity());
    }
}

