/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.io.Externalizable;
import java.io.IOException;
import java.io.Serializable;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.as.clustering.VersionedMarshallingConfiguration;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.Creator;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ModularClassResolver;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.marshalling.reflect.ReflectiveCreator;
import org.jboss.marshalling.reflect.SunReflectiveCreator;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;

public class SessionAttributeMarshallingContext
implements ClassTable,
VersionedMarshallingConfiguration {
    private static final int CURRENT_VERSION = 1;
    private final Map<Integer, MarshallingConfiguration> configurations = new ConcurrentHashMap<Integer, MarshallingConfiguration>();
    private static final Class<?>[] classes = new Class[]{Serializable.class, Externalizable.class};
    private static final Map<Class<?>, ClassTable.Writer> writers = SessionAttributeMarshallingContext.createWriters();

    public SessionAttributeMarshallingContext(Module module) {
        this(Marshalling.getMarshallerFactory((String)"river", (ClassLoader)Marshalling.class.getClassLoader()), module);
    }

    public SessionAttributeMarshallingContext(MarshallerFactory factory, Module module) {
        ModularClassResolver resolver = ModularClassResolver.getInstance((ModuleLoader)module.getModuleLoader());
        MarshallingConfiguration configuration = new MarshallingConfiguration();
        configuration.setClassResolver((ClassResolver)resolver);
        configuration.setSerializedCreator((Creator)new SunReflectiveCreator());
        configuration.setExternalizerCreator((Creator)new ReflectiveCreator());
        configuration.setClassTable((ClassTable)this);
        this.configurations.put(1, configuration);
    }

    public int getCurrentMarshallingVersion() {
        return 1;
    }

    public MarshallingConfiguration getMarshallingConfiguration(int version) {
        MarshallingConfiguration config = this.configurations.get(version);
        if (config == null) {
            throw new IllegalArgumentException(String.valueOf(version));
        }
        return config;
    }

    private static Map<Class<?>, ClassTable.Writer> createWriters() {
        IdentityHashMap writers = new IdentityHashMap();
        for (int i = 0; i < classes.length; ++i) {
            writers.put(classes[i], new ByteWriter((byte)i));
        }
        return writers;
    }

    public ClassTable.Writer getClassWriter(Class<?> targetClass) throws IOException {
        return writers.get(targetClass);
    }

    public Class<?> readClass(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        return classes[unmarshaller.readUnsignedByte()];
    }

    private static final class ByteWriter
    implements ClassTable.Writer {
        final byte[] bytes;

        ByteWriter(byte ... bytes) {
            this.bytes = bytes;
        }

        public void writeClass(Marshaller marshaller, Class<?> clazz) throws IOException {
            marshaller.write(this.bytes);
        }
    }
}

