/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.infinispan.Cache;
import org.infinispan.affinity.KeyAffinityService;
import org.infinispan.affinity.KeyGenerator;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryActivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryPassivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryActivatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryPassivatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.concurrent.ConcurrentHashSet;
import org.jboss.as.clustering.infinispan.affinity.KeyAffinityServiceFactory;
import org.jboss.as.clustering.registry.Registry;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.wildfly.clustering.web.Batcher;
import org.wildfly.clustering.web.infinispan.InfinispanWebLogger;
import org.wildfly.clustering.web.infinispan.Scheduler;
import org.wildfly.clustering.web.infinispan.session.ExpiredSessionRemover;
import org.wildfly.clustering.web.infinispan.session.SessionEvictionScheduler;
import org.wildfly.clustering.web.infinispan.session.SessionExpirationScheduler;
import org.wildfly.clustering.web.infinispan.session.SessionFactory;
import org.wildfly.clustering.web.infinispan.session.Time;
import org.wildfly.clustering.web.session.ImmutableHttpSessionAdapter;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;
import org.wildfly.clustering.web.session.Session;
import org.wildfly.clustering.web.session.SessionAttributes;
import org.wildfly.clustering.web.session.SessionContext;
import org.wildfly.clustering.web.session.SessionIdentifierFactory;
import org.wildfly.clustering.web.session.SessionManager;
import org.wildfly.clustering.web.session.SessionMetaData;

@Listener
public class InfinispanSessionManager<V, L>
implements SessionManager<L>,
KeyGenerator<String>,
Batcher {
    private final SessionContext context;
    private final Cache<String, V> cache;
    private final SessionFactory<V, L> factory;
    private final SessionIdentifierFactory idFactory;
    private final KeyAffinityService<String> affinity;
    private final Registry<String, Void> registry;
    private final List<Scheduler<Session<L>>> schedulers = new CopyOnWriteArrayList<Scheduler<Session<L>>>();
    private volatile Time defaultMaxInactiveInterval = new Time(30L, TimeUnit.MINUTES);
    private final Set<String> activeSessions = new ConcurrentHashSet();
    private final int maxActiveSessions;

    public InfinispanSessionManager(SessionContext context, SessionIdentifierFactory idFactory, Cache<String, V> cache, SessionFactory<V, L> factory, KeyAffinityServiceFactory affinityFactory, Registry<String, Void> registry, JBossWebMetaData metaData) {
        this.context = context;
        this.factory = factory;
        this.idFactory = idFactory;
        this.cache = cache;
        this.affinity = affinityFactory.createService(this.cache, (KeyGenerator)this);
        this.registry = registry;
        this.maxActiveSessions = metaData.getMaxActiveSessions();
    }

    public void start() {
        this.cache.addListener((Object)this);
        this.affinity.start();
        this.schedulers.add(new SessionExpirationScheduler(this, new ExpiredSessionRemover<V, L>(this.factory)));
        if (this.maxActiveSessions > 0) {
            this.schedulers.add(new SessionEvictionScheduler(this, this.factory, this.maxActiveSessions));
        }
    }

    public void stop() {
        for (Scheduler<Session<L>> scheduler : this.schedulers) {
            scheduler.close();
        }
        this.schedulers.clear();
        this.affinity.stop();
        this.cache.removeListener((Object)this);
    }

    public boolean startBatch() {
        return this.cache.startBatch();
    }

    public void endBatch(boolean successful) {
        this.cache.endBatch(successful);
    }

    public String locate(String sessionId) {
        Map.Entry entry;
        Address location = this.locatePrimaryOwner(sessionId);
        if (location != null && !location.equals(this.cache.getCacheManager().getAddress()) && (entry = this.registry.getRemoteEntry((Object)location)) != null) {
            return (String)entry.getKey();
        }
        entry = this.registry.getLocalEntry();
        if (entry == null) {
            entry = this.registry.refreshLocalEntry();
        }
        return entry != null ? (String)entry.getKey() : null;
    }

    private Address locatePrimaryOwner(String sessionId) {
        DistributionManager dist = this.cache.getAdvancedCache().getDistributionManager();
        return dist != null ? dist.getPrimaryLocation((Object)sessionId) : this.cache.getCacheManager().getAddress();
    }

    public Batcher getBatcher() {
        return this;
    }

    public long getDefaultMaxInactiveInterval(TimeUnit unit) {
        return this.defaultMaxInactiveInterval.convert(unit);
    }

    public void setDefaultMaxInactiveInterval(long value, TimeUnit unit) {
        this.defaultMaxInactiveInterval = new Time(value, unit);
    }

    public String getKey() {
        return this.idFactory.createSessionId();
    }

    public String createSessionId() {
        return (String)this.affinity.getKeyForAddress(this.cache.getCacheManager().getAddress());
    }

    public boolean containsSession(String id) {
        return this.cache.containsKey((Object)id);
    }

    public Session<L> findSession(String id) {
        Object value = this.factory.findValue(id);
        if (value == null) {
            InfinispanWebLogger.ROOT_LOGGER.tracef("Session %s not found", id);
            return null;
        }
        Session<L> session = this.factory.createSession(id, value);
        if (session.getMetaData().isExpired()) {
            InfinispanWebLogger.ROOT_LOGGER.tracef("Session %s was found, but has expired", id);
            session.invalidate();
            return null;
        }
        for (Scheduler<Session<L>> scheduler : this.schedulers) {
            scheduler.cancel(session);
        }
        this.activeSessions.add(id);
        return new SchedulableSession<L>(session, this.schedulers);
    }

    public Session<L> createSession(String id) {
        Session<L> session = this.factory.createSession(id, this.factory.createValue(id));
        Time time = this.defaultMaxInactiveInterval;
        session.getMetaData().setMaxInactiveInterval(time.getValue(), time.getUnit());
        this.activeSessions.add(id);
        return new SchedulableSession<L>(session, this.schedulers);
    }

    public int size() {
        return this.activeSessions.size();
    }

    @CacheEntryActivated
    public void activated(CacheEntryActivatedEvent<String, ?> event) {
        if (!event.isPre() && event.isOriginLocal() && event.getKey() instanceof String) {
            String id = (String)event.getKey();
            InfinispanWebLogger.ROOT_LOGGER.tracef("Session %s was activated", id);
            ImmutableSession session = this.factory.createImmutableSession(id, this.factory.findValue(id));
            ImmutableSessionAttributes attributes = session.getAttributes();
            HttpSessionEvent sessionEvent = new HttpSessionEvent((HttpSession)new ImmutableHttpSessionAdapter(session));
            for (String attribute : attributes.getAttributeNames()) {
                Object value = attributes.getAttribute(attribute);
                if (!(value instanceof HttpSessionActivationListener)) continue;
                HttpSessionActivationListener listener = (HttpSessionActivationListener)value;
                listener.sessionDidActivate(sessionEvent);
            }
        }
    }

    @CacheEntryPassivated
    public void passivated(CacheEntryPassivatedEvent<String, ?> event) {
        if (event.isPre() && event.getKey() instanceof String) {
            String id = (String)event.getKey();
            this.activeSessions.remove(id);
            if (event.isOriginLocal()) {
                InfinispanWebLogger.ROOT_LOGGER.tracef("Session %s will be passivated", id);
                Session<L> session = this.factory.createSession(id, this.factory.findValue(id));
                ImmutableSessionAttributes attributes = session.getAttributes();
                HttpSessionEvent sessionEvent = new HttpSessionEvent((HttpSession)new ImmutableHttpSessionAdapter(session));
                for (String attribute : attributes.getAttributeNames()) {
                    Object value = attributes.getAttribute(attribute);
                    if (!(value instanceof HttpSessionActivationListener)) continue;
                    HttpSessionActivationListener listener = (HttpSessionActivationListener)value;
                    listener.sessionWillPassivate(sessionEvent);
                }
            }
        }
    }

    @CacheEntryRemoved
    public void removed(CacheEntryRemovedEvent<String, ?> event) {
        if (event.isPre() && event.isOriginLocal() && event.getKey() instanceof String) {
            String id = (String)event.getKey();
            this.activeSessions.remove(id);
            if (event.isOriginLocal()) {
                InfinispanWebLogger.ROOT_LOGGER.tracef("Session %s will be removed", id);
                ImmutableSession session = this.factory.createImmutableSession(id, this.factory.findValue(id));
                ImmutableSessionAttributes attributes = session.getAttributes();
                ImmutableHttpSessionAdapter httpSession = new ImmutableHttpSessionAdapter(session);
                HttpSessionEvent sessionEvent = new HttpSessionEvent((HttpSession)httpSession);
                for (HttpSessionListener listener : this.context.getSessionListeners()) {
                    listener.sessionDestroyed(sessionEvent);
                }
                for (String attribute : attributes.getAttributeNames()) {
                    Object value = attributes.getAttribute(attribute);
                    if (!(value instanceof HttpSessionBindingListener)) continue;
                    HttpSessionBindingListener listener = (HttpSessionBindingListener)value;
                    listener.valueUnbound(new HttpSessionBindingEvent((HttpSession)httpSession, attribute, value));
                }
            }
        }
    }

    private static class SchedulableSession<L>
    implements Session<L> {
        private final Session<L> session;
        private final List<Scheduler<Session<L>>> schedulers;

        SchedulableSession(Session<L> session, List<Scheduler<Session<L>>> schedulers) {
            this.session = session;
            this.schedulers = schedulers;
        }

        public String getId() {
            return this.session.getId();
        }

        public SessionMetaData getMetaData() {
            return this.session.getMetaData();
        }

        public boolean isValid() {
            return this.session.isValid();
        }

        public void invalidate() {
            this.session.invalidate();
        }

        public SessionAttributes getAttributes() {
            return this.session.getAttributes();
        }

        public SessionContext getContext() {
            return this.session.getContext();
        }

        public void close() {
            this.session.close();
            for (Scheduler<Session<L>> scheduler : this.schedulers) {
                scheduler.schedule(this.session);
            }
        }

        public L getLocalContext() {
            return (L)this.session.getLocalContext();
        }
    }
}

