/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.sso;

import java.util.concurrent.atomic.AtomicReference;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.infinispan.Remover;
import org.wildfly.clustering.web.sso.Credentials;
import org.wildfly.clustering.web.sso.SSO;
import org.wildfly.clustering.web.sso.Sessions;

public class InfinispanSSO<L>
implements SSO<L> {
    private final String id;
    private final Credentials credentials;
    private final Sessions sessions;
    private final AtomicReference<L> localContext;
    private final LocalContextFactory<L> localContextFactory;
    private final Remover<String> remover;

    public InfinispanSSO(String id, Credentials credentials, Sessions sessions, AtomicReference<L> localContext, LocalContextFactory<L> localContextFactory, Remover<String> remover) {
        this.id = id;
        this.credentials = credentials;
        this.sessions = sessions;
        this.localContext = localContext;
        this.localContextFactory = localContextFactory;
        this.remover = remover;
    }

    public String getId() {
        return this.id;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public Sessions getSessions() {
        return this.sessions;
    }

    public void invalidate() {
        this.remover.remove(this.id);
    }

    public L getLocalContext() {
        if (this.localContextFactory == null) {
            return null;
        }
        Object localContext = this.localContext.get();
        if (localContext == null && !this.localContext.compareAndSet(null, localContext = this.localContextFactory.createLocalContext())) {
            return this.localContext.get();
        }
        return localContext;
    }
}

