/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import org.infinispan.Cache;
import org.infinispan.remoting.transport.Address;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.group.NodeFactory;
import org.wildfly.clustering.registry.Registry;
import org.wildfly.clustering.spi.CacheServiceNames;
import org.wildfly.clustering.web.infinispan.session.InfinispanRouteLocator;
import org.wildfly.clustering.web.infinispan.session.InfinispanRouteLocatorConfiguration;
import org.wildfly.clustering.web.session.RouteLocator;

public class InfinispanRouteLocatorService
implements Service<RouteLocator>,
InfinispanRouteLocatorConfiguration {
    private final InjectedValue<NodeFactory> factory = new InjectedValue();
    private final InjectedValue<Registry> registry = new InjectedValue();
    private final InjectedValue<Cache> cache = new InjectedValue();
    private volatile RouteLocator locator = null;

    public static ServiceBuilder<RouteLocator> build(ServiceTarget target, ServiceName name, String deploymentName) {
        InfinispanRouteLocatorService service = new InfinispanRouteLocatorService();
        return target.addService(name, (Service)service).addDependency(CacheServiceNames.NODE_FACTORY.getServiceName("web"), NodeFactory.class, service.factory).addDependency(CacheServiceNames.REGISTRY.getServiceName("web"), Registry.class, service.registry).addDependency(InfinispanRouteLocatorService.getCacheServiceAlias(deploymentName), Cache.class, service.cache);
    }

    public static ServiceName getCacheServiceAlias(String deploymentName) {
        return ServiceName.JBOSS.append(new String[]{"clustering", "web", "locator", deploymentName});
    }

    private InfinispanRouteLocatorService() {
    }

    public RouteLocator getValue() {
        return this.locator;
    }

    public void start(StartContext context) {
        this.locator = new InfinispanRouteLocator(this);
    }

    public void stop(StopContext context) {
        this.locator = null;
    }

    @Override
    public Cache<String, ?> getCache() {
        return (Cache)this.cache.getValue();
    }

    @Override
    public Registry<String, Void> getRegistry() {
        return (Registry)this.registry.getValue();
    }

    @Override
    public NodeFactory<Address> getNodeFactory() {
        return (NodeFactory)this.factory.getValue();
    }
}

