/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session.coarse;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.TransactionConfiguration;
import org.infinispan.context.Flag;
import org.infinispan.transaction.LockingMode;
import org.jboss.as.clustering.marshalling.MarshalledValue;
import org.jboss.as.clustering.marshalling.MarshallingContext;
import org.wildfly.clustering.ee.infinispan.CacheEntryMutator;
import org.wildfly.clustering.ee.infinispan.Mutator;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.infinispan.logging.InfinispanWebLogger;
import org.wildfly.clustering.web.infinispan.session.InfinispanImmutableSession;
import org.wildfly.clustering.web.infinispan.session.InfinispanSession;
import org.wildfly.clustering.web.infinispan.session.SessionAttributeMarshaller;
import org.wildfly.clustering.web.infinispan.session.SessionFactory;
import org.wildfly.clustering.web.infinispan.session.SimpleSessionMetaData;
import org.wildfly.clustering.web.infinispan.session.coarse.CoarseImmutableSessionAttributes;
import org.wildfly.clustering.web.infinispan.session.coarse.CoarseSessionAttributes;
import org.wildfly.clustering.web.infinispan.session.coarse.CoarseSessionCacheEntry;
import org.wildfly.clustering.web.infinispan.session.coarse.CoarseSessionEntry;
import org.wildfly.clustering.web.infinispan.session.coarse.SessionAttributesCacheKey;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;
import org.wildfly.clustering.web.session.Session;
import org.wildfly.clustering.web.session.SessionContext;
import org.wildfly.clustering.web.session.SessionMetaData;

public class CoarseSessionFactory<L>
implements SessionFactory<CoarseSessionEntry<L>, L> {
    private final SessionContext context;
    private final Cache<String, CoarseSessionCacheEntry<L>> sessionCache;
    private final Cache<SessionAttributesCacheKey, MarshalledValue<Map<String, Object>, MarshallingContext>> attributesCache;
    private final SessionAttributeMarshaller<Map<String, Object>, MarshalledValue<Map<String, Object>, MarshallingContext>> marshaller;
    private final LocalContextFactory<L> localContextFactory;

    public CoarseSessionFactory(Cache<String, CoarseSessionCacheEntry<L>> sessionCache, Cache<SessionAttributesCacheKey, MarshalledValue<Map<String, Object>, MarshallingContext>> attributesCache, SessionContext context, SessionAttributeMarshaller<Map<String, Object>, MarshalledValue<Map<String, Object>, MarshallingContext>> marshaller, LocalContextFactory<L> localContextFactory) {
        this.sessionCache = sessionCache;
        this.attributesCache = attributesCache;
        this.context = context;
        this.marshaller = marshaller;
        this.localContextFactory = localContextFactory;
    }

    @Override
    public Session<L> createSession(String id, CoarseSessionEntry<L> entry) {
        CoarseSessionCacheEntry<L> cacheEntry = entry.getCacheEntry();
        SessionMetaData metaData = cacheEntry.getMetaData();
        MarshalledValue<Map<String, Object>, MarshallingContext> value = entry.getAttributes();
        Mutator attributesMutator = metaData.isNew() ? Mutator.PASSIVE : new CacheEntryMutator(this.attributesCache, (Object)new SessionAttributesCacheKey(id), value);
        CoarseSessionAttributes attributes = new CoarseSessionAttributes(value, this.marshaller, attributesMutator);
        Mutator sessionMutator = metaData.isNew() ? Mutator.PASSIVE : new CacheEntryMutator(this.sessionCache, (Object)id, cacheEntry);
        return new InfinispanSession<L>(id, metaData, attributes, cacheEntry.getLocalContext(), this.localContextFactory, this.context, sessionMutator, this);
    }

    @Override
    public ImmutableSession createImmutableSession(String id, CoarseSessionEntry<L> entry) {
        CoarseSessionCacheEntry<L> cacheEntry = entry.getCacheEntry();
        SessionMetaData metaData = cacheEntry.getMetaData();
        MarshalledValue<Map<String, Object>, MarshallingContext> value = entry.getAttributes();
        CoarseImmutableSessionAttributes attributes = new CoarseImmutableSessionAttributes(value, this.marshaller);
        return new InfinispanImmutableSession(id, (ImmutableSessionMetaData)metaData, attributes, this.context);
    }

    public CoarseSessionEntry<L> createValue(String id) {
        CoarseSessionCacheEntry entry = new CoarseSessionCacheEntry(new SimpleSessionMetaData());
        CoarseSessionCacheEntry existingEntry = (CoarseSessionCacheEntry)this.sessionCache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).putIfAbsent((Object)id, entry);
        if (existingEntry != null) {
            MarshalledValue value = (MarshalledValue)this.attributesCache.get((Object)new SessionAttributesCacheKey(id));
            return new CoarseSessionEntry(existingEntry, (MarshalledValue<Map<String, Object>, MarshallingContext>)value);
        }
        HashMap map = new HashMap();
        MarshalledValue<Map<String, Object>, MarshallingContext> value = this.marshaller.write(map);
        MarshalledValue<Map<String, Object>, MarshallingContext> existingValue = (MarshalledValue<Map<String, Object>, MarshallingContext>)this.attributesCache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).putIfAbsent((Object)new SessionAttributesCacheKey(id), value);
        return new CoarseSessionEntry(entry, existingValue != null ? existingValue : value);
    }

    public CoarseSessionEntry<L> findValue(String id) {
        TransactionConfiguration transaction = this.sessionCache.getCacheConfiguration().transaction();
        boolean pessimistic = transaction.transactionMode().isTransactional() && transaction.lockingMode() == LockingMode.PESSIMISTIC;
        AdvancedCache cache = pessimistic ? this.sessionCache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_WRITE_LOCK}) : this.sessionCache;
        CoarseSessionCacheEntry entry = (CoarseSessionCacheEntry)cache.get((Object)id);
        if (entry == null) {
            return null;
        }
        MarshalledValue value = (MarshalledValue)this.attributesCache.get((Object)new SessionAttributesCacheKey(id));
        return new CoarseSessionEntry(entry, (MarshalledValue<Map<String, Object>, MarshallingContext>)value);
    }

    public void remove(String id) {
        this.sessionCache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).remove((Object)id);
        this.attributesCache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).remove((Object)new SessionAttributesCacheKey(id));
    }

    public void evict(String id) {
        try {
            this.sessionCache.evict((Object)id);
            this.attributesCache.evict((Object)new SessionAttributesCacheKey(id));
        }
        catch (Throwable e) {
            InfinispanWebLogger.ROOT_LOGGER.failedToPassivateSession(e, id);
        }
    }
}

