/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.sso;

import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.as.clustering.infinispan.subsystem.CacheConfigurationService;
import org.jboss.as.clustering.infinispan.subsystem.CacheService;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.as.clustering.infinispan.subsystem.GlobalComponentRegistryService;
import org.jboss.as.clustering.msc.AsynchronousService;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.jboss.tm.XAResourceRecoveryRegistry;
import org.wildfly.clustering.ee.infinispan.TransactionBatch;
import org.wildfly.clustering.web.infinispan.sso.InfinispanSSOManagerFactory;
import org.wildfly.clustering.web.infinispan.sso.SSOCacheConfigurationService;
import org.wildfly.clustering.web.sso.SSOManagerFactory;
import org.wildfly.clustering.web.sso.SSOManagerFactoryBuilder;

public class InfinispanSSOManagerFactoryBuilder
implements SSOManagerFactoryBuilder<TransactionBatch> {
    public static final String DEFAULT_CACHE_CONTAINER = "web";

    public <A, D> ServiceBuilder<SSOManagerFactory<A, D, TransactionBatch>> build(ServiceTarget target, ServiceName name, String host) {
        String containerName = DEFAULT_CACHE_CONTAINER;
        ServiceName containerServiceName = EmbeddedCacheManagerService.getServiceName((String)containerName);
        String templateCacheName = "default";
        String cacheName = host;
        ServiceName cacheConfigurationServiceName = CacheConfigurationService.getServiceName((String)containerName, (String)cacheName);
        ServiceName cacheServiceName = CacheService.getServiceName((String)containerName, (String)cacheName);
        SSOCacheConfigurationService.build(target, containerName, cacheName, templateCacheName).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        final InjectedValue cacheContainer = new InjectedValue();
        CacheService.Dependencies dependencies = new CacheService.Dependencies(){

            public EmbeddedCacheManager getCacheContainer() {
                return (EmbeddedCacheManager)cacheContainer.getValue();
            }

            public XAResourceRecoveryRegistry getRecoveryRegistry() {
                return null;
            }
        };
        AsynchronousService.addService((ServiceTarget)target, (ServiceName)cacheServiceName, (Service)new CacheService(cacheName, dependencies)).addDependency(GlobalComponentRegistryService.getServiceName((String)containerName)).addDependency(cacheConfigurationServiceName).addDependency(containerServiceName, EmbeddedCacheManager.class, (Injector)cacheContainer).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        return InfinispanSSOManagerFactory.build(target, name, containerName, cacheName);
    }
}

