/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session.fine;

import java.util.Set;
import java.util.TreeSet;
import org.infinispan.Cache;
import org.wildfly.clustering.marshalling.InvalidSerializedFormException;
import org.wildfly.clustering.marshalling.Marshaller;
import org.wildfly.clustering.web.infinispan.logging.InfinispanWebLogger;
import org.wildfly.clustering.web.infinispan.session.fine.SessionAttributeCacheKey;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;

public class FineImmutableSessionAttributes<V>
implements ImmutableSessionAttributes {
    private final String id;
    private final Cache<SessionAttributeCacheKey, V> cache;
    private final Marshaller<Object, V> marshaller;

    public FineImmutableSessionAttributes(String id, Cache<SessionAttributeCacheKey, V> attributeCache, Marshaller<Object, V> marshaller) {
        this.id = id;
        this.cache = attributeCache;
        this.marshaller = marshaller;
    }

    public Set<String> getAttributeNames() {
        TreeSet<String> attributes = new TreeSet<String>();
        for (SessionAttributeCacheKey key : this.cache.getAdvancedCache().getGroup(this.id).keySet()) {
            attributes.add(key.getAttribute());
        }
        return attributes;
    }

    public Object getAttribute(String name) {
        SessionAttributeCacheKey key = this.createKey(name);
        return this.read(name, this.cache.get((Object)key));
    }

    protected SessionAttributeCacheKey createKey(String attribute) {
        return new SessionAttributeCacheKey(this.id, attribute);
    }

    protected Object read(String name, V value) {
        try {
            return this.marshaller.read(value);
        }
        catch (InvalidSerializedFormException e) {
            throw InfinispanWebLogger.ROOT_LOGGER.failedToReadSessionAttribute(e, this.id, name);
        }
    }
}

