/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.sso;

import io.undertow.security.api.AuthenticatedSessionManager;
import io.undertow.security.idm.Account;
import io.undertow.security.impl.SingleSignOn;
import io.undertow.security.impl.SingleSignOnManager;
import java.util.Base64;
import org.jboss.logging.Logger;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.web.sso.SSO;
import org.wildfly.clustering.web.sso.SSOManager;
import org.wildfly.clustering.web.undertow.sso.DistributableSingleSignOn;
import org.wildfly.clustering.web.undertow.sso.InvalidatableSingleSignOn;
import org.wildfly.clustering.web.undertow.sso.SessionManagerRegistry;

public class DistributableSingleSignOnManager
implements SingleSignOnManager {
    private static final Logger log = Logger.getLogger(DistributableSingleSignOnManager.class);
    private final SSOManager<AuthenticatedSessionManager.AuthenticatedSession, String, Void, Batch> manager;
    private final SessionManagerRegistry registry;

    public DistributableSingleSignOnManager(SSOManager<AuthenticatedSessionManager.AuthenticatedSession, String, Void, Batch> manager, SessionManagerRegistry registry) {
        this.manager = manager;
        this.registry = registry;
    }

    public SingleSignOn createSingleSignOn(Account account, String mechanism) {
        String id = (String)this.manager.createIdentifier();
        Batcher batcher = this.manager.getBatcher();
        Batch batch = batcher.createBatch();
        try {
            AuthenticatedSessionManager.AuthenticatedSession session = new AuthenticatedSessionManager.AuthenticatedSession(account, mechanism);
            SSO sso = this.manager.createSSO(id, (Object)session);
            if (log.isTraceEnabled()) {
                log.tracef("Creating SSO ID %s for Principal %s and Roles %s", (Object)id, (Object)account.getPrincipal().getName(), (Object)account.getRoles().toString());
            }
            return new DistributableSingleSignOn((SSO<AuthenticatedSessionManager.AuthenticatedSession, String, Void>)sso, this.registry, (Batcher<Batch>)batcher, batcher.suspendBatch());
        }
        catch (Error | RuntimeException e) {
            batch.discard();
            batch.close();
            throw e;
        }
    }

    public SingleSignOn findSingleSignOn(String id) {
        try {
            Base64.getUrlDecoder().decode(id);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        Batcher batcher = this.manager.getBatcher();
        Batch batch = batcher.createBatch();
        try {
            SSO sso = this.manager.findSSO(id);
            if (sso == null) {
                if (log.isTraceEnabled()) {
                    log.tracef("SSO ID %s not found on the session manager.", (Object)id);
                }
                batch.close();
                return null;
            }
            if (log.isTraceEnabled()) {
                log.tracef("SSO ID %s found on the session manager.", (Object)id);
            }
            return new DistributableSingleSignOn((SSO<AuthenticatedSessionManager.AuthenticatedSession, String, Void>)sso, this.registry, (Batcher<Batch>)batcher, batcher.suspendBatch());
        }
        catch (Error | RuntimeException e) {
            batch.discard();
            batch.close();
            throw e;
        }
    }

    public void removeSingleSignOn(SingleSignOn sso) {
        if (sso instanceof InvalidatableSingleSignOn) {
            if (log.isTraceEnabled()) {
                log.tracef("Removing SSO ID %s", (Object)sso.getId());
            }
            ((InvalidatableSingleSignOn)sso).invalidate();
        }
    }
}

