/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import io.undertow.servlet.api.SessionManagerFactory;
import io.undertow.servlet.core.InMemorySessionManagerFactory;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.clustering.controller.SimpleCapabilityServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.web.session.SessionManagerFactoryBuilderProvider;
import org.wildfly.clustering.web.undertow.session.DistributableSessionManagerFactoryBuilder;
import org.wildfly.extension.undertow.logging.UndertowLogger;
import org.wildfly.extension.undertow.session.DistributableSessionManagerConfiguration;

public class DistributableSessionManagerFactoryBuilderProvider
implements org.wildfly.extension.undertow.session.DistributableSessionManagerFactoryBuilderProvider {
    private static final SessionManagerFactoryBuilderProvider<Batch> PROVIDER = DistributableSessionManagerFactoryBuilderProvider.loadProvider();

    private static SessionManagerFactoryBuilderProvider<Batch> loadProvider() {
        Iterator<SessionManagerFactoryBuilderProvider> iterator = ServiceLoader.load(SessionManagerFactoryBuilderProvider.class, SessionManagerFactoryBuilderProvider.class.getClassLoader()).iterator();
        if (iterator.hasNext()) {
            SessionManagerFactoryBuilderProvider provider = iterator.next();
            return provider;
        }
        return null;
    }

    public CapabilityServiceBuilder<SessionManagerFactory> getBuilder(ServiceName name, DistributableSessionManagerConfiguration configuration) {
        if (PROVIDER == null) {
            UndertowLogger.ROOT_LOGGER.clusteringNotSupported();
            return new SimpleCapabilityServiceBuilder(name, (Object)new InMemorySessionManagerFactory(configuration.getMaxActiveSessions()));
        }
        return new DistributableSessionManagerFactoryBuilder(name, configuration, PROVIDER);
    }
}

