/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import java.util.Collections;
import java.util.EnumSet;
import java.util.ServiceLoader;
import org.jboss.modules.Module;
import org.wildfly.clustering.ee.CompositeIterable;
import org.wildfly.clustering.ee.Immutability;
import org.wildfly.clustering.ee.immutable.CompositeImmutability;
import org.wildfly.clustering.ee.immutable.DefaultImmutability;
import org.wildfly.clustering.marshalling.jboss.MarshallingConfigurationRepository;
import org.wildfly.clustering.marshalling.jboss.MarshallingContext;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshalledValueFactory;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshallingConfigurationRepository;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshallingContextFactory;
import org.wildfly.clustering.marshalling.spi.MarshalledValueFactory;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.container.WebDeploymentConfiguration;
import org.wildfly.clustering.web.session.SessionAttributeImmutability;
import org.wildfly.clustering.web.session.SessionManagerFactoryConfiguration;
import org.wildfly.clustering.web.undertow.session.DistributableSessionManagerFactoryServiceConfigurator;
import org.wildfly.clustering.web.undertow.session.LocalSessionContext;
import org.wildfly.clustering.web.undertow.session.LocalSessionContextFactory;
import org.wildfly.clustering.web.undertow.session.UndertowSessionAttributeImmutability;
import org.wildfly.clustering.web.undertow.session.WebDeploymentConfigurationAdapter;

public class SessionManagerFactoryConfigurationAdapter
extends WebDeploymentConfigurationAdapter
implements SessionManagerFactoryConfiguration<MarshallingContext, LocalSessionContext> {
    private final Integer maxActiveSessions;
    private final MarshallingContext context;
    private final MarshalledValueFactory<MarshallingContext> marshalledValueFactory;
    private final LocalContextFactory<LocalSessionContext> localContextFactory = new LocalSessionContextFactory();
    private final Immutability immutability;

    public SessionManagerFactoryConfigurationAdapter(org.wildfly.clustering.web.container.SessionManagerFactoryConfiguration configuration, Immutability immutability) {
        super((WebDeploymentConfiguration)configuration);
        this.maxActiveSessions = configuration.getMaxActiveSessions();
        Module module = configuration.getModule();
        this.context = new SimpleMarshallingContextFactory().createMarshallingContext((MarshallingConfigurationRepository)new SimpleMarshallingConfigurationRepository(DistributableSessionManagerFactoryServiceConfigurator.MarshallingVersion.class, (Enum)DistributableSessionManagerFactoryServiceConfigurator.MarshallingVersion.CURRENT, (Object)module), (ClassLoader)module.getClassLoader());
        this.marshalledValueFactory = new SimpleMarshalledValueFactory(this.context);
        ServiceLoader<Immutability> loadedImmutability = ServiceLoader.load(Immutability.class, Immutability.class.getClassLoader());
        this.immutability = new CompositeImmutability((Iterable)new CompositeIterable(new Iterable[]{EnumSet.allOf(DefaultImmutability.class), EnumSet.allOf(SessionAttributeImmutability.class), EnumSet.allOf(UndertowSessionAttributeImmutability.class), loadedImmutability, Collections.singleton(immutability)}));
    }

    public Integer getMaxActiveSessions() {
        return this.maxActiveSessions;
    }

    public MarshalledValueFactory<MarshallingContext> getMarshalledValueFactory() {
        return this.marshalledValueFactory;
    }

    public MarshallingContext getMarshallingContext() {
        return this.context;
    }

    public LocalContextFactory<LocalSessionContext> getLocalContextFactory() {
        return this.localContextFactory;
    }

    public Immutability getImmutability() {
        return this.immutability;
    }
}

