/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import io.undertow.UndertowMessages;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionListener;
import io.undertow.server.session.SessionListeners;
import io.undertow.server.session.SessionManagerStatistics;
import io.undertow.util.AttachmentKey;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.web.IdentifierMarshaller;
import org.wildfly.clustering.web.session.Session;
import org.wildfly.clustering.web.session.SessionManager;
import org.wildfly.clustering.web.session.oob.OOBSession;
import org.wildfly.clustering.web.undertow.UndertowIdentifierSerializerProvider;
import org.wildfly.clustering.web.undertow.logging.UndertowClusteringLogger;
import org.wildfly.clustering.web.undertow.session.DistributableSession;
import org.wildfly.clustering.web.undertow.session.LocalSessionContextFactory;
import org.wildfly.clustering.web.undertow.session.RecordableSessionManagerStatistics;
import org.wildfly.clustering.web.undertow.session.SimpleSessionConfig;
import org.wildfly.clustering.web.undertow.session.UndertowSessionManager;
import org.wildfly.common.function.Functions;

public class DistributableSessionManager
implements UndertowSessionManager,
Consumer<HttpServerExchange>,
LongConsumer {
    private static final IdentifierMarshaller IDENTIFIER_MARSHALLER = new UndertowIdentifierSerializerProvider().getMarshaller();
    private final AttachmentKey<io.undertow.server.session.Session> key = AttachmentKey.create(io.undertow.server.session.Session.class);
    private final String deploymentName;
    private final SessionListeners listeners;
    private final SessionManager<Map<String, Object>, Batch> manager;
    private final RecordableSessionManagerStatistics statistics;
    private final StampedLock lifecycleLock = new StampedLock();
    private OptionalLong lifecycleStamp = OptionalLong.empty();

    public DistributableSessionManager(String deploymentName, SessionManager<Map<String, Object>, Batch> manager, SessionListeners listeners, RecordableSessionManagerStatistics statistics) {
        this.deploymentName = deploymentName;
        this.manager = manager;
        this.listeners = listeners;
        this.statistics = statistics;
    }

    @Override
    public SessionListeners getSessionListeners() {
        return this.listeners;
    }

    @Override
    public SessionManager<Map<String, Object>, Batch> getSessionManager() {
        return this.manager;
    }

    public synchronized void start() {
        this.lifecycleStamp.ifPresent(this);
        this.manager.start();
        if (this.statistics != null) {
            this.statistics.reset();
        }
    }

    @Override
    public void accept(long stamp) {
        this.lifecycleLock.unlock(stamp);
        this.lifecycleStamp = OptionalLong.empty();
    }

    public synchronized void stop() {
        if (!this.lifecycleStamp.isPresent()) {
            Duration stopTimeout = this.manager.getStopTimeout();
            try {
                long stamp = this.lifecycleLock.tryWriteLock(stopTimeout.getSeconds(), TimeUnit.SECONDS);
                if (stamp != 0L) {
                    this.lifecycleStamp = OptionalLong.of(stamp);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.manager.stop();
    }

    private Consumer<HttpServerExchange> getSessionCloseTask() {
        final StampedLock lock = this.lifecycleLock;
        long stamp = lock.tryReadLock();
        if (stamp == 0L) {
            throw UndertowClusteringLogger.ROOT_LOGGER.sessionManagerStopped();
        }
        final AttachmentKey<io.undertow.server.session.Session> key = this.key;
        final AtomicLong stampRef = new AtomicLong(stamp);
        return new Consumer<HttpServerExchange>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void accept(HttpServerExchange exchange) {
                try {
                    long stamp = stampRef.getAndSet(0L);
                    if (stamp != 0L) {
                        lock.unlock(stamp);
                    }
                }
                finally {
                    if (exchange != null) {
                        exchange.removeAttachment(key);
                    }
                }
            }
        };
    }

    @Override
    public void accept(HttpServerExchange exchange) {
        if (exchange != null) {
            exchange.removeAttachment(this.key);
        }
    }

    /*
     * Loose catch block
     */
    public io.undertow.server.session.Session createSession(HttpServerExchange exchange, SessionConfig config) {
        if (config == null) {
            throw UndertowMessages.MESSAGES.couldNotFindSessionCookieConfig();
        }
        String requestedId = config.findSessionId(exchange);
        boolean close = true;
        Consumer<HttpServerExchange> closeTask = this.getSessionCloseTask();
        try {
            String id = requestedId == null ? (String)this.manager.createIdentifier() : requestedId;
            Batcher batcher = this.manager.getBatcher();
            Batch batch = batcher.createBatch();
            try {
                Session session = this.manager.createSession(id);
                if (session == null) {
                    throw UndertowClusteringLogger.ROOT_LOGGER.sessionAlreadyExists(id);
                }
                if (requestedId == null) {
                    config.setSessionId(exchange, id);
                }
                DistributableSession result = new DistributableSession(this, (Session<Map<String, Object>>)session, config, batcher.suspendBatch(), closeTask);
                this.listeners.sessionCreated((io.undertow.server.session.Session)result, exchange);
                if (this.statistics != null) {
                    this.statistics.record(result);
                }
                exchange.putAttachment(this.key, (Object)result);
                close = false;
                DistributableSession distributableSession = result;
                return distributableSession;
            }
            catch (Error | RuntimeException e) {
                batch.discard();
                throw e;
            }
            finally {
                if (close) {
                    batch.close();
                }
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (close) {
                closeTask.accept(exchange);
            }
        }
    }

    /*
     * Loose catch block
     */
    public io.undertow.server.session.Session getSession(HttpServerExchange exchange, SessionConfig config) {
        io.undertow.server.session.Session attachedSession;
        if (exchange != null && (attachedSession = (io.undertow.server.session.Session)exchange.getAttachment(this.key)) != null) {
            return attachedSession;
        }
        if (config == null) {
            throw UndertowMessages.MESSAGES.couldNotFindSessionCookieConfig();
        }
        String id = config.findSessionId(exchange);
        if (id == null) {
            return null;
        }
        if (!IDENTIFIER_MARSHALLER.validate(id)) {
            return null;
        }
        boolean close = true;
        Consumer<HttpServerExchange> closeTask = this.getSessionCloseTask();
        try {
            DistributableSession distributableSession;
            Batcher batcher = this.manager.getBatcher();
            Batch batch = batcher.createBatch();
            try {
                Session session = this.manager.findSession(id);
                if (session == null) {
                    io.undertow.server.session.Session session2 = null;
                    return session2;
                }
                DistributableSession result = new DistributableSession(this, (Session<Map<String, Object>>)session, config, batcher.suspendBatch(), closeTask);
                if (exchange != null) {
                    exchange.putAttachment(this.key, (Object)result);
                }
                close = false;
                distributableSession = result;
            }
            catch (Error | RuntimeException e) {
                batch.discard();
                throw e;
            }
            finally {
                if (close) {
                    batch.close();
                }
            }
            return distributableSession;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (close) {
                closeTask.accept(exchange);
            }
        }
    }

    public void registerSessionListener(SessionListener listener) {
        this.listeners.addSessionListener(listener);
    }

    public void removeSessionListener(SessionListener listener) {
        this.listeners.removeSessionListener(listener);
    }

    public void setDefaultSessionTimeout(int timeout) {
        this.manager.setDefaultMaxInactiveInterval(Duration.ofSeconds(timeout));
    }

    public Set<String> getTransientSessions() {
        return Collections.emptySet();
    }

    public Set<String> getActiveSessions() {
        return this.manager.getActiveSessions();
    }

    public Set<String> getAllSessions() {
        return this.manager.getLocalSessions();
    }

    public io.undertow.server.session.Session getSession(String sessionId) {
        if (!IDENTIFIER_MARSHALLER.validate(sessionId)) {
            return null;
        }
        OOBSession session = new OOBSession(this.manager, sessionId, LocalSessionContextFactory.INSTANCE.createLocalContext());
        return session.isValid() ? new DistributableSession(this, (Session<Map<String, Object>>)session, new SimpleSessionConfig(sessionId), null, Functions.discardingConsumer()) : null;
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public SessionManagerStatistics getStatistics() {
        return this.statistics;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DistributableSessionManager)) {
            return false;
        }
        DistributableSessionManager manager = (DistributableSessionManager)object;
        return this.deploymentName.equals(manager.getDeploymentName());
    }

    public int hashCode() {
        return this.deploymentName.hashCode();
    }

    public String toString() {
        return this.deploymentName;
    }
}

