/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import io.undertow.UndertowOptions;
import io.undertow.connector.ByteBufferPool;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.ServerConnection;
import io.undertow.server.protocol.http.HttpServerConnection;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionListener;
import io.undertow.server.session.SessionListeners;
import io.undertow.util.Protocols;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;
import org.wildfly.clustering.web.session.Session;
import org.wildfly.clustering.web.session.SessionManager;
import org.wildfly.clustering.web.session.SessionMetaData;
import org.wildfly.clustering.web.undertow.session.DistributableSessionManager;
import org.wildfly.clustering.web.undertow.session.DistributableSessionManagerConfiguration;
import org.wildfly.clustering.web.undertow.session.RecordableSessionManagerStatistics;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.StreamConnection;
import org.xnio.channels.Configurable;
import org.xnio.conduits.ConduitStreamSinkChannel;
import org.xnio.conduits.ConduitStreamSourceChannel;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.StreamSourceConduit;

public class DistributableSessionManagerTestCase {
    private final String deploymentName = "mydeployment.war";
    private final SessionManager<Map<String, Object>, Batch> manager = (SessionManager)Mockito.mock(SessionManager.class);
    private final SessionListener listener = (SessionListener)Mockito.mock(SessionListener.class);
    private final SessionListeners listeners = new SessionListeners();
    private final RecordableSessionManagerStatistics statistics = (RecordableSessionManagerStatistics)Mockito.mock(RecordableSessionManagerStatistics.class);
    private DistributableSessionManager adapter;

    @Before
    public void init() {
        DistributableSessionManagerConfiguration config = (DistributableSessionManagerConfiguration)Mockito.mock(DistributableSessionManagerConfiguration.class);
        Mockito.when((Object)config.getDeploymentName()).thenReturn((Object)this.deploymentName);
        Mockito.when((Object)config.getSessionListeners()).thenReturn((Object)this.listeners);
        Mockito.when((Object)config.getSessionManager()).thenReturn(this.manager);
        Mockito.when((Object)config.getStatistics()).thenReturn((Object)this.statistics);
        Mockito.when((Object)config.isOrphanSessionAllowed()).thenReturn((Object)false);
        this.adapter = new DistributableSessionManager(config);
        this.adapter.registerSessionListener(this.listener);
    }

    @Test
    public void getDeploymentName() {
        Assert.assertSame((Object)this.deploymentName, (Object)this.adapter.getDeploymentName());
    }

    @Test
    public void start() {
        this.adapter.start();
        ((SessionManager)Mockito.verify(this.manager)).start();
        ((RecordableSessionManagerStatistics)Mockito.verify((Object)this.statistics)).reset();
    }

    @Test
    public void stop() {
        Mockito.when((Object)this.manager.getStopTimeout()).thenReturn((Object)Duration.ZERO);
        this.adapter.stop();
        ((SessionManager)Mockito.verify(this.manager)).stop();
    }

    @Test
    public void setDefaultSessionTimeout() {
        this.adapter.setDefaultSessionTimeout(10);
        ((SessionManager)Mockito.verify(this.manager)).setDefaultMaxInactiveInterval(Duration.ofSeconds(10L));
    }

    @Test
    public void createSessionResponseCommitted() {
        Configurable configurable = (Configurable)Mockito.mock(Configurable.class);
        StreamSourceConduit sourceConduit = (StreamSourceConduit)Mockito.mock(StreamSourceConduit.class);
        ConduitStreamSourceChannel sourceChannel = new ConduitStreamSourceChannel(configurable, sourceConduit);
        StreamSinkConduit sinkConduit = (StreamSinkConduit)Mockito.mock(StreamSinkConduit.class);
        ConduitStreamSinkChannel sinkChannel = new ConduitStreamSinkChannel(configurable, sinkConduit);
        StreamConnection stream = (StreamConnection)Mockito.mock(StreamConnection.class);
        Mockito.when((Object)stream.getSourceChannel()).thenReturn((Object)sourceChannel);
        Mockito.when((Object)stream.getSinkChannel()).thenReturn((Object)sinkChannel);
        ByteBufferPool bufferPool = (ByteBufferPool)Mockito.mock(ByteBufferPool.class);
        HttpHandler handler = (HttpHandler)Mockito.mock(HttpHandler.class);
        HttpServerConnection connection = new HttpServerConnection(stream, bufferPool, handler, OptionMap.create((Option)UndertowOptions.ALWAYS_SET_DATE, (Object)false), 0, null);
        HttpServerExchange exchange = new HttpServerExchange((ServerConnection)connection);
        exchange.setProtocol(Protocols.HTTP_1_1);
        exchange.getResponseChannel();
        SessionConfig config = (SessionConfig)Mockito.mock(SessionConfig.class);
        Assert.assertThrows(IllegalStateException.class, () -> this.adapter.createSession(exchange, config));
    }

    @Test
    public void createSessionNoSessionId() {
        HttpServerExchange exchange = new HttpServerExchange(null);
        Supplier identifierFactory = (Supplier)Mockito.mock(Supplier.class);
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        SessionConfig config = (SessionConfig)Mockito.mock(SessionConfig.class);
        Session session = (Session)Mockito.mock(Session.class);
        SessionMetaData metaData = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        String sessionId = "session";
        Mockito.when((Object)this.manager.getIdentifierFactory()).thenReturn((Object)identifierFactory);
        Mockito.when((Object)((String)identifierFactory.get())).thenReturn((Object)sessionId);
        Mockito.when((Object)this.manager.createSession(sessionId)).thenReturn((Object)session);
        Mockito.when((Object)this.manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.createBatch()).thenReturn((Object)batch);
        Mockito.when((Object)session.getId()).thenReturn((Object)sessionId);
        Mockito.when((Object)session.getMetaData()).thenReturn((Object)metaData);
        Mockito.when((Object)metaData.isNew()).thenReturn((Object)true);
        io.undertow.server.session.Session sessionAdapter = this.adapter.createSession(exchange, config);
        Assert.assertNotNull((Object)sessionAdapter);
        ((SessionListener)Mockito.verify((Object)this.listener)).sessionCreated(sessionAdapter, exchange);
        ((SessionConfig)Mockito.verify((Object)config)).setSessionId(exchange, sessionId);
        ((Batcher)Mockito.verify((Object)batcher)).suspendBatch();
        ((RecordableSessionManagerStatistics)Mockito.verify((Object)this.statistics)).record((Object)sessionAdapter);
        String expected = "expected";
        Mockito.when((Object)session.getId()).thenReturn((Object)expected);
        String result = sessionAdapter.getId();
        Assert.assertSame((Object)expected, (Object)result);
    }

    @Test
    public void createSessionSpecifiedSessionId() {
        HttpServerExchange exchange = new HttpServerExchange(null);
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        SessionConfig config = (SessionConfig)Mockito.mock(SessionConfig.class);
        Session session = (Session)Mockito.mock(Session.class);
        SessionMetaData metaData = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        String sessionId = "session";
        Mockito.when((Object)config.findSessionId(exchange)).thenReturn((Object)sessionId);
        Mockito.when((Object)this.manager.createSession(sessionId)).thenReturn((Object)session);
        Mockito.when((Object)this.manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.createBatch()).thenReturn((Object)batch);
        Mockito.when((Object)session.getId()).thenReturn((Object)sessionId);
        Mockito.when((Object)session.getMetaData()).thenReturn((Object)metaData);
        Mockito.when((Object)metaData.isNew()).thenReturn((Object)true);
        io.undertow.server.session.Session sessionAdapter = this.adapter.createSession(exchange, config);
        Assert.assertNotNull((Object)sessionAdapter);
        ((SessionListener)Mockito.verify((Object)this.listener)).sessionCreated(sessionAdapter, exchange);
        ((Batcher)Mockito.verify((Object)batcher)).suspendBatch();
        ((RecordableSessionManagerStatistics)Mockito.verify((Object)this.statistics)).record((Object)sessionAdapter);
        String expected = "expected";
        Mockito.when((Object)session.getId()).thenReturn((Object)expected);
        String result = sessionAdapter.getId();
        Assert.assertSame((Object)expected, (Object)result);
    }

    @Test
    public void createSessionAlreadyExists() {
        HttpServerExchange exchange = new HttpServerExchange(null);
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        SessionConfig config = (SessionConfig)Mockito.mock(SessionConfig.class);
        String sessionId = "session";
        Mockito.when((Object)config.findSessionId(exchange)).thenReturn((Object)sessionId);
        Mockito.when((Object)this.manager.createSession(sessionId)).thenReturn(null);
        Mockito.when((Object)this.manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.createBatch()).thenReturn((Object)batch);
        IllegalStateException exception = null;
        try {
            this.adapter.createSession(exchange, config);
        }
        catch (IllegalStateException e) {
            exception = e;
        }
        Assert.assertNotNull((Object)exception);
        ((Batch)Mockito.verify((Object)batch)).discard();
        ((Batch)Mockito.verify((Object)batch)).close();
    }

    @Test
    public void getSession() {
        HttpServerExchange exchange = new HttpServerExchange(null);
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        SessionConfig config = (SessionConfig)Mockito.mock(SessionConfig.class);
        Session session = (Session)Mockito.mock(Session.class);
        SessionMetaData metaData = (SessionMetaData)Mockito.mock(SessionMetaData.class);
        String sessionId = "session";
        Mockito.when((Object)config.findSessionId(exchange)).thenReturn((Object)sessionId);
        Mockito.when((Object)this.manager.findSession(sessionId)).thenReturn((Object)session);
        Mockito.when((Object)this.manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.createBatch()).thenReturn((Object)batch);
        Mockito.when((Object)session.getId()).thenReturn((Object)sessionId);
        Mockito.when((Object)session.getMetaData()).thenReturn((Object)metaData);
        Mockito.when((Object)metaData.isNew()).thenReturn((Object)false);
        io.undertow.server.session.Session sessionAdapter = this.adapter.getSession(exchange, config);
        Assert.assertNotNull((Object)sessionAdapter);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.statistics});
        ((Batcher)Mockito.verify((Object)batcher)).suspendBatch();
        String expected = "expected";
        Mockito.when((Object)session.getId()).thenReturn((Object)expected);
        String result = sessionAdapter.getId();
        Assert.assertSame((Object)expected, (Object)result);
    }

    @Test
    public void getSessionNoSessionId() {
        HttpServerExchange exchange = new HttpServerExchange(null);
        SessionConfig config = (SessionConfig)Mockito.mock(SessionConfig.class);
        Mockito.when((Object)config.findSessionId(exchange)).thenReturn(null);
        io.undertow.server.session.Session sessionAdapter = this.adapter.getSession(exchange, config);
        Assert.assertNull((Object)sessionAdapter);
    }

    @Test
    public void getSessionInvalidCharacters() {
        HttpServerExchange exchange = new HttpServerExchange(null);
        SessionConfig config = (SessionConfig)Mockito.mock(SessionConfig.class);
        String sessionId = "session+";
        Mockito.when((Object)config.findSessionId(exchange)).thenReturn((Object)sessionId);
        io.undertow.server.session.Session sessionAdapter = this.adapter.getSession(exchange, config);
        Assert.assertNull((Object)sessionAdapter);
        sessionAdapter = this.adapter.getSession(sessionId);
        Assert.assertNull((Object)sessionAdapter);
        ((SessionManager)Mockito.verify(this.manager, (VerificationMode)Mockito.never())).findSession(sessionId);
    }

    @Test
    public void getSessionNotExists() {
        HttpServerExchange exchange = new HttpServerExchange(null);
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        SessionConfig config = (SessionConfig)Mockito.mock(SessionConfig.class);
        String sessionId = "session";
        Mockito.when((Object)config.findSessionId(exchange)).thenReturn((Object)sessionId);
        Mockito.when((Object)this.manager.findSession(sessionId)).thenReturn(null);
        Mockito.when((Object)this.manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.createBatch()).thenReturn((Object)batch);
        io.undertow.server.session.Session sessionAdapter = this.adapter.getSession(exchange, config);
        Assert.assertNull((Object)sessionAdapter);
        ((Batch)Mockito.verify((Object)batch)).close();
        ((Batcher)Mockito.verify((Object)batcher, (VerificationMode)Mockito.never())).suspendBatch();
    }

    @Test
    public void activeSessions() {
        Mockito.when((Object)this.manager.getActiveSessions()).thenReturn(Collections.singleton("expected"));
        int result = this.adapter.getActiveSessions().size();
        Assert.assertEquals((long)1L, (long)result);
    }

    @Test
    public void getTransientSessions() {
        Set result = this.adapter.getTransientSessions();
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void getActiveSessions() {
        String expected = "expected";
        Mockito.when((Object)this.manager.getActiveSessions()).thenReturn(Collections.singleton(expected));
        Set result = this.adapter.getActiveSessions();
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertSame((Object)expected, result.iterator().next());
    }

    @Test
    public void getAllSessions() {
        String expected = "expected";
        Mockito.when((Object)this.manager.getLocalSessions()).thenReturn(Collections.singleton(expected));
        Set result = this.adapter.getAllSessions();
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertSame((Object)expected, result.iterator().next());
    }

    @Test
    public void getSessionByIdentifier() {
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        Batch batch1 = (Batch)Mockito.mock(Batch.class);
        Batch batch2 = (Batch)Mockito.mock(Batch.class);
        ImmutableSession session = (ImmutableSession)Mockito.mock(ImmutableSession.class);
        ImmutableSessionMetaData metaData = (ImmutableSessionMetaData)Mockito.mock(ImmutableSessionMetaData.class);
        String id = "ABC123";
        Mockito.when((Object)this.manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.createBatch()).thenReturn((Object)batch1, (Object[])new Batch[]{batch2});
        Mockito.when((Object)this.manager.readSession(id)).thenReturn((Object)session);
        Mockito.when((Object)session.getMetaData()).thenReturn((Object)metaData);
        Mockito.when((Object)metaData.isNew()).thenReturn((Object)false);
        io.undertow.server.session.Session result = this.adapter.getSession(id);
        Assert.assertSame((Object)id, (Object)result.getId());
        ((Batch)Mockito.verify((Object)batch1)).close();
        ((Batch)Mockito.verify((Object)batch2)).close();
    }

    @Test
    public void getSessionByIdentifierNotExists() {
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        String id = "ABC123";
        Mockito.when((Object)this.manager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.createBatch()).thenReturn((Object)batch);
        Mockito.when((Object)this.manager.readSession(id)).thenReturn(null);
        io.undertow.server.session.Session result = this.adapter.getSession(id);
        Assert.assertNull((Object)result);
        ((Batch)Mockito.verify((Object)batch)).close();
        Mockito.reset((Object[])new Batch[]{batch});
    }

    @Test
    public void getStatistics() {
        Assert.assertSame((Object)this.statistics, (Object)this.adapter.getStatistics());
    }
}

