/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionListener;
import io.undertow.server.session.SessionListeners;
import io.undertow.servlet.api.Deployment;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;
import org.wildfly.clustering.web.session.SessionManager;
import org.wildfly.clustering.web.undertow.session.UndertowSessionExpirationListener;
import org.wildfly.clustering.web.undertow.session.UndertowSessionManager;

public class UndertowSessionExpirationListenerTestCase {
    @Test
    public void sessionExpired() {
        Deployment deployment = (Deployment)Mockito.mock(Deployment.class);
        UndertowSessionManager manager = (UndertowSessionManager)Mockito.mock(UndertowSessionManager.class);
        SessionManager delegateManager = (SessionManager)Mockito.mock(SessionManager.class);
        Batcher batcher = (Batcher)Mockito.mock(Batcher.class);
        Batch batch = (Batch)Mockito.mock(Batch.class);
        SessionListener listener = (SessionListener)Mockito.mock(SessionListener.class);
        ImmutableSession session = (ImmutableSession)Mockito.mock(ImmutableSession.class);
        ImmutableSessionAttributes attributes = (ImmutableSessionAttributes)Mockito.mock(ImmutableSessionAttributes.class);
        ImmutableSessionMetaData metaData = (ImmutableSessionMetaData)Mockito.mock(ImmutableSessionMetaData.class);
        ArgumentCaptor capturedSession = ArgumentCaptor.forClass(Session.class);
        String expectedSessionId = "session";
        SessionListeners listeners = new SessionListeners();
        listeners.addSessionListener(listener);
        UndertowSessionExpirationListener expirationListener = new UndertowSessionExpirationListener(deployment, listeners);
        Mockito.when((Object)deployment.getSessionManager()).thenReturn((Object)manager);
        Mockito.when((Object)manager.getSessionManager()).thenReturn((Object)delegateManager);
        Mockito.when((Object)delegateManager.getBatcher()).thenReturn((Object)batcher);
        Mockito.when((Object)batcher.suspendBatch()).thenReturn((Object)batch);
        Mockito.when((Object)session.getId()).thenReturn((Object)expectedSessionId);
        Mockito.when((Object)session.getAttributes()).thenReturn((Object)attributes);
        Mockito.when((Object)attributes.getAttributeNames()).thenReturn(Collections.emptySet());
        Mockito.when((Object)session.getMetaData()).thenReturn((Object)metaData);
        Mockito.when((Object)metaData.getCreationTime()).thenReturn((Object)Instant.now());
        Mockito.when((Object)metaData.getLastAccessStartTime()).thenReturn((Object)Instant.now());
        Mockito.when((Object)metaData.getMaxInactiveInterval()).thenReturn((Object)Duration.ZERO);
        expirationListener.sessionExpired(session);
        ((Batcher)Mockito.verify((Object)batcher)).suspendBatch();
        ((SessionListener)Mockito.verify((Object)listener)).sessionDestroyed((Session)capturedSession.capture(), (HttpServerExchange)ArgumentMatchers.isNull(), (SessionListener.SessionDestroyedReason)ArgumentMatchers.same((Object)SessionListener.SessionDestroyedReason.TIMEOUT));
        ((Batcher)Mockito.verify((Object)batcher)).resumeBatch(batch);
        Assert.assertSame((Object)expectedSessionId, (Object)((Session)capturedSession.getValue()).getId());
        Assert.assertSame((Object)manager, (Object)((Session)capturedSession.getValue()).getSessionManager());
    }
}

