/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionActivationListener;
import jakarta.servlet.http.HttpSessionEvent;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.wildfly.clustering.web.session.HttpSessionActivationListenerProvider;
import org.wildfly.clustering.web.undertow.session.UndertowSpecificationProvider;

public class UndertowHttpSessionActivationListenerProviderTestCase {
    private HttpSessionActivationListenerProvider<HttpSession, ServletContext, HttpSessionActivationListener> provider = UndertowSpecificationProvider.INSTANCE;

    @Test
    public void prePassivateNotifier() {
        HttpSessionActivationListener listener = (HttpSessionActivationListener)Mockito.mock(HttpSessionActivationListener.class);
        ArgumentCaptor capturedEvent = ArgumentCaptor.forClass(HttpSessionEvent.class);
        ((HttpSessionActivationListener)Mockito.doNothing().when((Object)listener)).sessionWillPassivate((HttpSessionEvent)capturedEvent.capture());
        Consumer notifier = this.provider.prePassivateNotifier((Object)listener);
        HttpSession session = (HttpSession)Mockito.mock(HttpSession.class);
        notifier.accept(session);
        Assert.assertSame((Object)session, (Object)((HttpSessionEvent)capturedEvent.getValue()).getSession());
    }

    @Test
    public void postActivateNotifier() {
        HttpSessionActivationListener listener = (HttpSessionActivationListener)Mockito.mock(HttpSessionActivationListener.class);
        ArgumentCaptor capturedEvent = ArgumentCaptor.forClass(HttpSessionEvent.class);
        ((HttpSessionActivationListener)Mockito.doNothing().when((Object)listener)).sessionDidActivate((HttpSessionEvent)capturedEvent.capture());
        Consumer notifier = this.provider.postActivateNotifier((Object)listener);
        HttpSession session = (HttpSession)Mockito.mock(HttpSession.class);
        notifier.accept(session);
        Assert.assertSame((Object)session, (Object)((HttpSessionEvent)capturedEvent.getValue()).getSession());
    }

    @Test
    public void createListener() {
        Consumer prePassivate = (Consumer)Mockito.mock(Consumer.class);
        Consumer postActivate = (Consumer)Mockito.mock(Consumer.class);
        HttpSessionActivationListener listener = (HttpSessionActivationListener)this.provider.createListener(prePassivate, postActivate);
        HttpSession session = (HttpSession)Mockito.mock(HttpSession.class);
        HttpSessionEvent event = new HttpSessionEvent(session);
        listener.sessionWillPassivate(event);
        ((Consumer)Mockito.verify((Object)prePassivate)).accept(session);
        Mockito.verifyNoInteractions((Object[])new Object[]{postActivate});
        Mockito.reset((Object[])new Consumer[]{prePassivate, postActivate});
        listener.sessionDidActivate(event);
        Mockito.verifyNoInteractions((Object[])new Object[]{prePassivate});
        ((Consumer)Mockito.verify((Object)postActivate)).accept(session);
    }
}

