/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.user.elytron;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.session.user.User;
import org.wildfly.clustering.session.user.UserManager;
import org.wildfly.clustering.web.undertow.user.elytron.DistributableSingleSignOn;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.cache.CachedIdentity;
import org.wildfly.security.http.util.sso.SingleSignOn;
import org.wildfly.security.http.util.sso.SingleSignOnManager;

public class DistributableSingleSignOnManager
implements SingleSignOnManager {
    private final UserManager<CachedIdentity, AtomicReference<SecurityIdentity>, String, Map.Entry<String, URI>> manager;

    public DistributableSingleSignOnManager(UserManager<CachedIdentity, AtomicReference<SecurityIdentity>, String, Map.Entry<String, URI>> manager) {
        this.manager = manager;
    }

    public SingleSignOn create(String mechanismName, boolean programmatic, SecurityIdentity identity) {
        String id = (String)this.manager.getIdentifierFactory().get();
        Batch batch = (Batch)this.manager.getBatchFactory().get();
        try {
            User user = this.manager.createUser(id, (Object)new CachedIdentity(mechanismName, programmatic, identity));
            ((AtomicReference)user.getTransientContext()).set(identity);
            return new DistributableSingleSignOn((User<CachedIdentity, AtomicReference<SecurityIdentity>, String, Map.Entry<String, URI>>)user, batch.suspend());
        }
        catch (Error | RuntimeException e) {
            batch.discard();
            batch.close();
            throw e;
        }
    }

    public SingleSignOn find(String id) {
        Batch batch = (Batch)this.manager.getBatchFactory().get();
        boolean close = true;
        try {
            User user = this.manager.findUser(id);
            close = user == null;
            DistributableSingleSignOn distributableSingleSignOn = user != null ? new DistributableSingleSignOn((User<CachedIdentity, AtomicReference<SecurityIdentity>, String, Map.Entry<String, URI>>)user, batch.suspend()) : null;
            return distributableSingleSignOn;
        }
        catch (Error | RuntimeException e) {
            batch.discard();
            throw e;
        }
        finally {
            if (close) {
                batch.close();
            }
        }
    }
}

