/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import io.undertow.UndertowMessages;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionListener;
import io.undertow.server.session.SessionListeners;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.wildfly.clustering.web.Batch;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.Session;
import org.wildfly.clustering.web.session.SessionManager;
import org.wildfly.clustering.web.undertow.session.ImmutableSessionAdapter;
import org.wildfly.clustering.web.undertow.session.LocalSessionContext;
import org.wildfly.clustering.web.undertow.session.SessionAdapter;
import org.wildfly.clustering.web.undertow.session.UndertowSessionManager;

public class SessionManagerAdapter
implements UndertowSessionManager {
    private final SessionListeners sessionListeners = new SessionListeners();
    private final SessionManager<LocalSessionContext> manager;

    public SessionManagerAdapter(SessionManager<LocalSessionContext> manager) {
        this.manager = manager;
    }

    @Override
    public SessionListeners getSessionListeners() {
        return this.sessionListeners;
    }

    @Override
    public SessionManager<LocalSessionContext> getSessionManager() {
        return this.manager;
    }

    public Map.Entry<String, String> parse(String id) {
        int index = id != null ? id.indexOf(46) : -1;
        return index < 0 ? new AbstractMap.SimpleImmutableEntry<String, Object>(id, null) : new AbstractMap.SimpleImmutableEntry<String, String>(id.substring(0, index), id.substring(index + 1));
    }

    public String format(String sessionId, String routeId) {
        return routeId != null ? String.format("%s.%s", sessionId, routeId) : sessionId;
    }

    public String locate(String sessionId) {
        return this.manager.locate(sessionId);
    }

    public void start() {
        this.manager.start();
    }

    public void stop() {
        this.manager.stop();
    }

    public io.undertow.server.session.Session createSession(HttpServerExchange exchange, SessionConfig config) {
        if (config == null) {
            throw UndertowMessages.MESSAGES.couldNotFindSessionCookieConfig();
        }
        String id = this.findSessionId(exchange, config);
        if (id != null) {
            if (this.manager.containsSession(id)) {
                throw UndertowMessages.MESSAGES.sessionAlreadyExists(id);
            }
        } else {
            id = this.manager.createSessionId();
        }
        Batch batch = this.manager.getBatcher().startBatch();
        try {
            Session session = this.manager.createSession(id);
            io.undertow.server.session.Session adapter = this.getSession((Session<LocalSessionContext>)session, exchange, config, batch);
            this.sessionListeners.sessionCreated(adapter, exchange);
            return adapter;
        }
        catch (Error | RuntimeException e) {
            batch.discard();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public io.undertow.server.session.Session getSession(HttpServerExchange exchange, SessionConfig config) {
        String id = this.findSessionId(exchange, config);
        if (id == null) {
            return null;
        }
        Batch batch = this.manager.getBatcher().startBatch();
        Session session = null;
        try {
            session = this.manager.findSession(id);
            io.undertow.server.session.Session session2 = session != null ? this.getSession((Session<LocalSessionContext>)session, exchange, config, batch) : null;
            return session2;
        }
        finally {
            if (session == null) {
                batch.discard();
            }
        }
    }

    private String findSessionId(HttpServerExchange exchange, SessionConfig config) {
        String id = config.findSessionId(exchange);
        return this.parse(id).getKey();
    }

    private io.undertow.server.session.Session getSession(Session<LocalSessionContext> session, HttpServerExchange exchange, SessionConfig config, Batch batch) {
        SessionAdapter adapter = new SessionAdapter(this, session, config, batch);
        if (config != null) {
            String id = session.getId();
            String route = this.locate(id);
            config.setSessionId(exchange, route != null ? this.format(id, route) : id);
        }
        return adapter;
    }

    public void registerSessionListener(SessionListener listener) {
        this.sessionListeners.addSessionListener(listener);
    }

    public void removeSessionListener(SessionListener listener) {
        this.sessionListeners.removeSessionListener(listener);
    }

    public void setDefaultSessionTimeout(int timeout) {
        this.manager.setDefaultMaxInactiveInterval((long)timeout, TimeUnit.SECONDS);
    }

    public Set<String> getTransientSessions() {
        return Collections.emptySet();
    }

    public Set<String> getActiveSessions() {
        return this.manager.getActiveSessions();
    }

    public Set<String> getAllSessions() {
        return this.manager.getLocalSessions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public io.undertow.server.session.Session getSession(String sessionId) {
        Batch batch = this.manager.getBatcher().startBatch();
        try {
            ImmutableSession session = this.manager.viewSession(sessionId);
            ImmutableSessionAdapter immutableSessionAdapter = session != null ? new ImmutableSessionAdapter(this, session) : null;
            return immutableSessionAdapter;
        }
        finally {
            batch.discard();
        }
    }
}

