/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import io.undertow.servlet.api.SessionManagerFactory;
import java.util.EnumMap;
import java.util.Map;
import org.jboss.metadata.web.jboss.ReplicationGranularity;
import org.jboss.modules.Module;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.web.session.SessionManagerConfiguration;
import org.wildfly.clustering.web.session.SessionManagerFactoryBuilder;
import org.wildfly.clustering.web.session.SessionManagerFactoryBuilderValue;
import org.wildfly.clustering.web.undertow.session.DistributableSessionManagerFactoryService;
import org.wildfly.extension.undertow.session.DistributableSessionManagerConfiguration;

public class DistributableSessionManagerFactoryBuilder
implements org.wildfly.extension.undertow.session.DistributableSessionManagerFactoryBuilder {
    static final Map<ReplicationGranularity, SessionManagerConfiguration.SessionAttributePersistenceStrategy> strategies = new EnumMap<ReplicationGranularity, SessionManagerConfiguration.SessionAttributePersistenceStrategy>(ReplicationGranularity.class);
    private final SessionManagerFactoryBuilder builder;

    public DistributableSessionManagerFactoryBuilder() {
        this(new SessionManagerFactoryBuilderValue().getValue());
    }

    public DistributableSessionManagerFactoryBuilder(SessionManagerFactoryBuilder builder) {
        this.builder = builder;
    }

    public ServiceBuilder<SessionManagerFactory> build(ServiceTarget target, ServiceName name, final DistributableSessionManagerConfiguration config) {
        ServiceName clusteringServiceName = name.append(new String[]{"distributable"});
        SessionManagerConfiguration configuration = new SessionManagerConfiguration(){

            public int getMaxActiveSessions() {
                return config.getMaxActiveSessions();
            }

            public SessionManagerConfiguration.SessionAttributePersistenceStrategy getAttributePersistenceStrategy() {
                return strategies.get(config.getGranularity());
            }

            public String getDeploymentName() {
                return config.getDeploymentName();
            }

            public Module getModule() {
                return config.getModule();
            }

            public String getCacheName() {
                return config.getCacheName();
            }
        };
        this.builder.buildDeploymentDependency(target, clusteringServiceName, configuration).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        return DistributableSessionManagerFactoryService.build(target, name, clusteringServiceName);
    }

    static {
        strategies.put(ReplicationGranularity.SESSION, SessionManagerConfiguration.SessionAttributePersistenceStrategy.COARSE);
        strategies.put(ReplicationGranularity.ATTRIBUTE, SessionManagerConfiguration.SessionAttributePersistenceStrategy.FINE);
    }
}

