/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote.protocol.versionone;

import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinateTransaction;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinationManager;
import java.io.Closeable;
import java.io.IOException;
import javax.transaction.HeuristicCommitException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.remote.EJBRemoteTransactionsRepository;
import org.jboss.as.ejb3.remote.protocol.versionone.ChannelAssociation;
import org.jboss.as.ejb3.remote.protocol.versionone.TransactionRequestHandler;
import org.jboss.as.ejb3.remote.protocol.versionone.XidTransactionManagementTask;
import org.jboss.ejb.client.XidTransactionID;
import org.jboss.marshalling.MarshallerFactory;
import org.xnio.IoUtils;

class XidTransactionPrepareTask
extends XidTransactionManagementTask {
    XidTransactionPrepareTask(TransactionRequestHandler txRequestHandler, EJBRemoteTransactionsRepository transactionsRepository, MarshallerFactory marshallerFactory, XidTransactionID xidTransactionID, ChannelAssociation channelAssociation, short invocationId) {
        super(txRequestHandler, transactionsRepository, marshallerFactory, xidTransactionID, channelAssociation, invocationId);
    }

    @Override
    public void run() {
        try {
            this.manageTransaction();
        }
        catch (Throwable t) {
            try {
                this.transactionRequestHandler.writeException(this.channelAssociation, this.marshallerFactory, this.invocationId, t, null);
            }
            catch (IOException e) {
                EjbLogger.EJB3_INVOCATION_LOGGER.couldNotWriteOutToChannel(e);
                IoUtils.safeClose((Closeable)this.channelAssociation.getChannel());
            }
            return;
        }
    }

    @Override
    protected void manageTransaction() throws Throwable {
        int prepareResult = this.prepareTransaction();
        try {
            this.transactionRequestHandler.writeTxPrepareResponseMessage(this.channelAssociation, this.invocationId, prepareResult);
        }
        catch (IOException e) {
            EjbLogger.EJB3_INVOCATION_LOGGER.couldNotWriteInvocationSuccessMessage(e);
            IoUtils.safeClose((Closeable)this.channelAssociation.getChannel());
        }
    }

    private int prepareTransaction() throws Throwable {
        SubordinateTransaction subordinateTransaction = this.transactionsRepository.getImportedTransaction(this.xidTransactionID);
        if (subordinateTransaction == null) {
            SubordinateTransaction recoveredTransaction = this.tryRecoveryForImportedTransaction();
            if (recoveredTransaction == null && EjbLogger.EJB3_INVOCATION_LOGGER.isDebugEnabled()) {
                EjbLogger.EJB3_INVOCATION_LOGGER.debug("Not preparing " + this.xidTransactionID + " as is was not found on the server");
            }
            return 0;
        }
        this.resumeTransaction((Transaction)subordinateTransaction);
        try {
            int result = subordinateTransaction.doPrepare();
            switch (result) {
                case 2: {
                    SubordinationManager.getTransactionImporter().removeImportedTransaction(this.xidTransactionID.getXid());
                    int n = 3;
                    return n;
                }
                case 0: {
                    int n = 0;
                    return n;
                }
                case 1: {
                    Throwable initCause = null;
                    int xaExceptionCode = 100;
                    try {
                        subordinateTransaction.doRollback();
                    }
                    catch (HeuristicCommitException e) {
                        initCause = e;
                        xaExceptionCode = -3;
                    }
                    catch (HeuristicMixedException e) {
                        initCause = e;
                        xaExceptionCode = -3;
                    }
                    catch (SystemException e) {
                        initCause = e;
                        xaExceptionCode = -3;
                    }
                    catch (HeuristicRollbackException e) {
                        initCause = e;
                        xaExceptionCode = -3;
                    }
                    SubordinationManager.getTransactionImporter().removeImportedTransaction(this.xidTransactionID.getXid());
                    XAException xaException = new XAException(xaExceptionCode);
                    if (initCause != null) {
                        xaException.initCause(initCause);
                    }
                    throw xaException;
                }
                case 11: {
                    throw new XAException(-4);
                }
            }
            throw new XAException(104);
        }
        finally {
            this.transactionsRepository.getTransactionManager().suspend();
        }
    }
}

