/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.singleton;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.TransactionManagementType;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentCreateServiceFactory;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewConfigurator;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ee.component.ViewInstanceFactory;
import org.jboss.as.ee.component.deployers.StartupCountdown;
import org.jboss.as.ee.component.interceptors.InterceptorClassDescription;
import org.jboss.as.ee.component.serialization.WriteReplaceInterface;
import org.jboss.as.ee.metadata.MetadataCompleteMarker;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.EJBViewDescription;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.component.interceptors.ComponentTypeIdentityInterceptorFactory;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.component.session.StatelessRemoteViewInstanceFactory;
import org.jboss.as.ejb3.component.session.StatelessWriteReplaceInterceptor;
import org.jboss.as.ejb3.component.singleton.SingletonComponentCreateServiceFactory;
import org.jboss.as.ejb3.component.singleton.SingletonComponentInstanceAssociationInterceptor;
import org.jboss.as.ejb3.component.singleton.StartupCountDownInterceptor;
import org.jboss.as.ejb3.concurrency.ContainerManagedConcurrencyInterceptorFactory;
import org.jboss.as.ejb3.deployment.EjbJarDescription;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.security.SecurityContextInterceptorFactory;
import org.jboss.as.ejb3.tx.EjbBMTInterceptor;
import org.jboss.as.ejb3.tx.LifecycleCMTTxInterceptor;
import org.jboss.as.ejb3.tx.TimerCMTTxInterceptor;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.metadata.ejb.spec.SessionBeanMetaData;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.ServiceName;

public class SingletonComponentDescription
extends SessionBeanComponentDescription {
    private boolean initOnStartup;
    private final List<ServiceName> dependsOn = new ArrayList<ServiceName>();

    public SingletonComponentDescription(String componentName, String componentClassName, EjbJarDescription ejbJarDescription, ServiceName deploymentUnitServiceName, SessionBeanMetaData descriptorData) {
        super(componentName, componentClassName, ejbJarDescription, deploymentUnitServiceName, descriptorData);
        this.getConfigurators().add(new ComponentConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                configuration.addTimeoutViewInterceptor(SingletonComponentInstanceAssociationInterceptor.FACTORY, 1792);
                ConcurrencyManagementType concurrencyManagementType = SingletonComponentDescription.this.getConcurrencyManagementType();
                if (concurrencyManagementType == null || concurrencyManagementType == ConcurrencyManagementType.CONTAINER) {
                    configuration.addTimeoutViewInterceptor((InterceptorFactory)new ContainerManagedConcurrencyInterceptorFactory(Collections.emptyMap()), 576);
                }
            }
        });
    }

    public ComponentConfiguration createConfiguration(ClassReflectionIndex classIndex, ClassLoader moduleClassLoader, ModuleLoader moduleLoader) {
        ComponentConfiguration singletonComponentConfiguration = new ComponentConfiguration((ComponentDescription)this, classIndex, moduleClassLoader, moduleLoader);
        singletonComponentConfiguration.setComponentCreateServiceFactory((ComponentCreateServiceFactory)new SingletonComponentCreateServiceFactory(this.isInitOnStartup(), this.dependsOn));
        if (this.isExplicitSecurityDomainConfigured()) {
            this.getConfigurators().add(new ComponentConfigurator(){

                public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                    DeploymentUnit deploymentUnit = context.getDeploymentUnit();
                    String contextID = deploymentUnit.getName();
                    if (deploymentUnit.getParent() != null) {
                        contextID = deploymentUnit.getParent().getName() + "!" + contextID;
                    }
                    EJBComponentDescription ejbComponentDescription = (EJBComponentDescription)description;
                    if (SingletonComponentDescription.this.isSecurityDomainKnown()) {
                        HashMap<Integer, InterceptorFactory> elytronInterceptorFactories = SingletonComponentDescription.this.getElytronInterceptorFactories(contextID, ejbComponentDescription.isEnableJacc());
                        elytronInterceptorFactories.forEach((priority, elytronInterceptorFactory) -> configuration.addPostConstructInterceptor(elytronInterceptorFactory, priority.intValue()));
                    } else {
                        configuration.addPostConstructInterceptor((InterceptorFactory)new SecurityContextInterceptorFactory(SingletonComponentDescription.this.isExplicitSecurityDomainConfigured(), false, contextID), 592);
                    }
                }
            });
        }
        this.getConfigurators().add(new ComponentConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                if (SingletonComponentDescription.this.isInitOnStartup()) {
                    StartupCountdown startupCountdown = (StartupCountdown)context.getDeploymentUnit().getAttachment(org.jboss.as.ee.component.Attachments.STARTUP_COUNTDOWN);
                    configuration.addPostConstructInterceptor((InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)new StartupCountDownInterceptor(startupCountdown)), 80);
                }
            }
        });
        if (this.getTransactionManagementType().equals((Object)TransactionManagementType.CONTAINER)) {
            this.getConfigurators().add(new ComponentConfigurator(){

                public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                    EEApplicationClasses applicationClasses = (EEApplicationClasses)context.getDeploymentUnit().getAttachment(org.jboss.as.ee.component.Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
                    InterceptorClassDescription interceptorConfig = ComponentDescription.mergeInterceptorConfig((Class)configuration.getComponentClass(), (EEModuleClassDescription)applicationClasses.getClassByName(description.getComponentClassName()), (ComponentDescription)description, (boolean)MetadataCompleteMarker.isMetadataComplete((DeploymentUnit)context.getDeploymentUnit()));
                    if (interceptorConfig.getPostConstruct() != null) {
                        configuration.addPostConstructInterceptor((InterceptorFactory)new LifecycleCMTTxInterceptor.Factory(interceptorConfig.getPostConstruct(), true), 1280);
                    }
                    configuration.addPreDestroyInterceptor((InterceptorFactory)new LifecycleCMTTxInterceptor.Factory(interceptorConfig.getPreDestroy(), true), 768);
                    configuration.addTimeoutViewInterceptor(TimerCMTTxInterceptor.FACTORY, 1280);
                }
            });
        } else {
            this.getConfigurators().add(new ComponentConfigurator(){

                public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                    configuration.addPostConstructInterceptor(EjbBMTInterceptor.FACTORY, 1280);
                    configuration.addPreDestroyInterceptor(EjbBMTInterceptor.FACTORY, 768);
                    configuration.addComponentInterceptor(EjbBMTInterceptor.FACTORY, 1312, false);
                }
            });
        }
        return singletonComponentConfiguration;
    }

    public boolean isInitOnStartup() {
        return this.initOnStartup;
    }

    public void initOnStartup() {
        this.initOnStartup = true;
    }

    @Override
    public boolean allowsConcurrentAccess() {
        return true;
    }

    @Override
    public SessionBeanComponentDescription.SessionBeanType getSessionBeanType() {
        return SessionBeanComponentDescription.SessionBeanType.SINGLETON;
    }

    @Override
    protected void setupViewInterceptors(EJBViewDescription view) {
        super.setupViewInterceptors(view);
        this.addViewSerializationInterceptor(view);
        this.addConcurrencyManagementInterceptor(view);
        view.getConfigurators().addFirst(new ViewConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                for (Method method : configuration.getProxyFactory().getCachedMethods()) {
                    if ((!method.getName().equals("hashCode") || method.getParameterTypes().length != 0) && (!method.getName().equals("equals") || method.getParameterTypes().length != 1 || method.getParameterTypes()[0] != Object.class)) continue;
                    configuration.addClientInterceptor(method, (InterceptorFactory)ComponentTypeIdentityInterceptorFactory.INSTANCE, 1024);
                }
                configuration.addViewInterceptor(SingletonComponentInstanceAssociationInterceptor.FACTORY, 1792);
            }
        });
        if (view.getMethodIntf() == MethodIntf.REMOTE) {
            view.getConfigurators().add(new ViewConfigurator(){

                public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                    String earApplicationName = componentConfiguration.getComponentDescription().getModuleDescription().getEarApplicationName();
                    configuration.setViewInstanceFactory((ViewInstanceFactory)new StatelessRemoteViewInstanceFactory(earApplicationName, componentConfiguration.getModuleName(), componentConfiguration.getComponentDescription().getModuleDescription().getDistinctName(), componentConfiguration.getComponentName()));
                }
            });
        }
    }

    private void addViewSerializationInterceptor(ViewDescription view) {
        view.setSerializable(true);
        view.setUseWriteReplace(true);
        view.getConfigurators().add(new ViewConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                DeploymentReflectionIndex index = (DeploymentReflectionIndex)context.getDeploymentUnit().getAttachment(Attachments.REFLECTION_INDEX);
                ClassReflectionIndex classIndex = index.getClassIndex(WriteReplaceInterface.class);
                for (Method method : classIndex.getMethods()) {
                    configuration.addClientInterceptor(method, StatelessWriteReplaceInterceptor.factory(configuration.getViewServiceName().getCanonicalName()), 1280);
                }
            }
        });
    }

    @Override
    protected ViewConfigurator getSessionBeanObjectViewConfigurator() {
        throw EjbLogger.ROOT_LOGGER.ejb2xViewNotApplicableForSingletonBeans();
    }

    private void addConcurrencyManagementInterceptor(ViewDescription view) {
        view.getConfigurators().add(new ViewConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                SingletonComponentDescription singletonComponentDescription = (SingletonComponentDescription)componentConfiguration.getComponentDescription();
                if (singletonComponentDescription.getConcurrencyManagementType() == ConcurrencyManagementType.BEAN) {
                    return;
                }
                configuration.addViewInterceptor((InterceptorFactory)new ContainerManagedConcurrencyInterceptorFactory(configuration.getViewToComponentMethodMap()), 576);
            }
        });
    }

    public List<ServiceName> getDependsOn() {
        return this.dependsOn;
    }

    public boolean isTimerServiceApplicable() {
        return true;
    }
}

