/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote;

import java.net.URI;
import java.security.AccessController;
import java.util.List;
import org.jboss.as.ejb3.remote.RemotingProfileService;
import org.jboss.as.ejb3.subsystem.EJBClientConfiguratorService;
import org.jboss.as.remoting.AbstractOutboundConnectionService;
import org.jboss.ejb.client.DeploymentNodeSelector;
import org.jboss.ejb.client.EJBClientCluster;
import org.jboss.ejb.client.EJBClientConnection;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBTransportProvider;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.common.context.Contextual;
import org.wildfly.security.auth.client.AuthenticationContext;

public final class EJBClientContextService
implements Service<EJBClientContextService> {
    public static final ServiceName APP_CLIENT_URI_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"ejb3", "ejbClientContext", "appClientUri"});
    private static final ServiceName BASE_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"ejb3", "ejbClientContext"});
    public static final ServiceName DEPLOYMENT_BASE_SERVICE_NAME = BASE_SERVICE_NAME.append(new String[]{"deployment"});
    public static final ServiceName DEFAULT_SERVICE_NAME = BASE_SERVICE_NAME.append(new String[]{"default"});
    private EJBClientContext clientContext;
    private final InjectedValue<EJBClientConfiguratorService> configuratorServiceInjector = new InjectedValue();
    private final InjectedValue<EJBTransportProvider> localProviderInjector = new InjectedValue();
    private final InjectedValue<RemotingProfileService> profileServiceInjector = new InjectedValue();
    private InjectedValue<URI> appClientUri = new InjectedValue();
    private final boolean makeGlobal;
    private long invocationTimeout;
    private DeploymentNodeSelector deploymentNodeSelector;
    private List<EJBClientCluster> clientClusters = null;
    private AuthenticationContext clustersAuthenticationContext = null;

    public EJBClientContextService(boolean makeGlobal) {
        this.makeGlobal = makeGlobal;
    }

    public EJBClientContextService() {
        this.makeGlobal = false;
    }

    public void start(StartContext context) throws StartException {
        RemotingProfileService profileService;
        EJBClientContext.Builder builder = new EJBClientContext.Builder();
        ((EJBClientConfiguratorService)this.configuratorServiceInjector.getValue()).accept(builder);
        builder.setInvocationTimeout(this.invocationTimeout);
        EJBTransportProvider localTransport = (EJBTransportProvider)this.localProviderInjector.getOptionalValue();
        if (localTransport != null) {
            builder.addTransportProvider(localTransport);
        }
        if ((profileService = (RemotingProfileService)this.profileServiceInjector.getOptionalValue()) != null) {
            for (RemotingProfileService.ConnectionSpec spec : profileService.getConnectionSpecs()) {
                EJBClientConnection.Builder connBuilder = new EJBClientConnection.Builder();
                connBuilder.setDestination(((AbstractOutboundConnectionService)spec.getInjector().getValue()).getDestinationUri());
                builder.addClientConnection(connBuilder.build());
            }
        }
        if (this.appClientUri.getOptionalValue() != null) {
            EJBClientConnection.Builder connBuilder = new EJBClientConnection.Builder();
            connBuilder.setDestination((URI)this.appClientUri.getOptionalValue());
            builder.addClientConnection(connBuilder.build());
        }
        if (this.clientClusters != null) {
            for (EJBClientCluster clientCluster : this.clientClusters) {
                builder.addClientCluster(clientCluster);
            }
        }
        if (this.deploymentNodeSelector != null) {
            builder.setDeploymentNodeSelector(this.deploymentNodeSelector);
        }
        this.clientContext = builder.build();
        if (this.makeGlobal) {
            AccessController.doPrivileged(() -> {
                EJBClientContext.getContextManager().setGlobalDefault((Contextual)this.clientContext);
                return null;
            });
        }
    }

    public void stop(StopContext context) {
        this.clientContext = null;
        if (this.makeGlobal) {
            AccessController.doPrivileged(() -> {
                EJBClientContext.getContextManager().setGlobalDefault(null);
                return null;
            });
        }
    }

    public EJBClientContextService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public EJBClientContext getClientContext() {
        return this.clientContext;
    }

    public InjectedValue<EJBClientConfiguratorService> getConfiguratorServiceInjector() {
        return this.configuratorServiceInjector;
    }

    public InjectedValue<EJBTransportProvider> getLocalProviderInjector() {
        return this.localProviderInjector;
    }

    public InjectedValue<RemotingProfileService> getProfileServiceInjector() {
        return this.profileServiceInjector;
    }

    public InjectedValue<URI> getAppClientUri() {
        return this.appClientUri;
    }

    public void setInvocationTimeout(long invocationTimeout) {
        this.invocationTimeout = invocationTimeout;
    }

    public void setDeploymentNodeSelector(DeploymentNodeSelector deploymentNodeSelector) {
        this.deploymentNodeSelector = deploymentNodeSelector;
    }

    public void setClientClusters(List<EJBClientCluster> clientClusters) {
        this.clientClusters = clientClusters;
    }

    public void setClustersAuthenticationContext(AuthenticationContext clustersAuthenticationContext) {
        this.clustersAuthenticationContext = clustersAuthenticationContext;
    }

    public AuthenticationContext getClustersAuthenticationContext() {
        return this.clustersAuthenticationContext;
    }
}

