/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ControlledProcessStateService;
import org.jboss.as.ejb3.remote.AssociationService;
import org.jboss.as.remoting.RemotingConnectorBindingInfoService;
import org.jboss.ejb.protocol.remote.RemoteEJBService;
import org.jboss.ejb.server.Association;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.OpenListener;
import org.jboss.remoting3.Registration;
import org.jboss.remoting3.ServiceRegistrationException;
import org.wildfly.transaction.client.provider.remoting.RemotingTransactionService;
import org.xnio.OptionMap;

public class EJBRemoteConnectorService
implements Service<EJBRemoteConnectorService> {
    private static final String EJB_CHANNEL_NAME = "jboss.ejb";
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"ejb3", "connector"});
    private final InjectedValue<Endpoint> endpointValue = new InjectedValue();
    private final InjectedValue<ExecutorService> executorService = new InjectedValue();
    private final InjectedValue<RemotingConnectorBindingInfoService.RemotingConnectorInfo> remotingConnectorInfoInjectedValue = new InjectedValue();
    private final InjectedValue<AssociationService> associationServiceInjectedValue = new InjectedValue();
    private final InjectedValue<RemotingTransactionService> remotingTransactionServiceInjectedValue = new InjectedValue();
    private final InjectedValue<ControlledProcessStateService> controlledProcessStateServiceInjectedValue = new InjectedValue();
    private volatile Registration registration;
    private final OptionMap channelCreationOptions;

    public EJBRemoteConnectorService() {
        this(OptionMap.EMPTY);
    }

    public EJBRemoteConnectorService(OptionMap channelCreationOptions) {
        this.channelCreationOptions = channelCreationOptions;
    }

    public void start(StartContext context) throws StartException {
        AssociationService associationService = (AssociationService)this.associationServiceInjectedValue.getValue();
        Endpoint endpoint = (Endpoint)this.endpointValue.getValue();
        Executor executor = (Executor)this.executorService.getOptionalValue();
        if (executor != null) {
            associationService.setExecutor(executor);
        }
        final RemoteEJBService remoteEJBService = RemoteEJBService.create((Association)associationService.getAssociation(), (RemotingTransactionService)((RemotingTransactionService)this.remotingTransactionServiceInjectedValue.getValue()));
        final ControlledProcessStateService processStateService = (ControlledProcessStateService)this.controlledProcessStateServiceInjectedValue.getValue();
        if (processStateService.getCurrentState() == ControlledProcessState.State.STARTING) {
            PropertyChangeListener listener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("currentState") && evt.getOldValue() == ControlledProcessState.State.STARTING) {
                        remoteEJBService.serverUp();
                        processStateService.removePropertyChangeListener((PropertyChangeListener)this);
                    }
                }
            };
            processStateService.addPropertyChangeListener(listener);
            if (processStateService.getCurrentState() != ControlledProcessState.State.STARTING) {
                remoteEJBService.serverUp();
                processStateService.removePropertyChangeListener(listener);
            }
        } else {
            remoteEJBService.serverUp();
        }
        OpenListener channelOpenListener = remoteEJBService.getOpenListener();
        try {
            this.registration = endpoint.registerService(EJB_CHANNEL_NAME, channelOpenListener, this.channelCreationOptions);
        }
        catch (ServiceRegistrationException e) {
            throw new StartException((Throwable)e);
        }
    }

    public void stop(StopContext context) {
        ((AssociationService)this.associationServiceInjectedValue.getValue()).setExecutor(null);
        this.registration.close();
    }

    public String getProtocol() {
        return ((RemotingConnectorBindingInfoService.RemotingConnectorInfo)this.remotingConnectorInfoInjectedValue.getValue()).getProtocol();
    }

    public EJBRemoteConnectorService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<Endpoint> getEndpointInjector() {
        return this.endpointValue;
    }

    public InjectedValue<RemotingConnectorBindingInfoService.RemotingConnectorInfo> getRemotingConnectorInfoInjectedValue() {
        return this.remotingConnectorInfoInjectedValue;
    }

    public InjectedValue<RemotingTransactionService> getRemotingTransactionServiceInjector() {
        return this.remotingTransactionServiceInjectedValue;
    }

    public InjectedValue<ControlledProcessStateService> getControlledProcessStateServiceInjector() {
        return this.controlledProcessStateServiceInjectedValue;
    }

    public InjectedValue<AssociationService> getAssociationServiceInjector() {
        return this.associationServiceInjectedValue;
    }

    public InjectedValue<ExecutorService> getExecutorService() {
        return this.executorService;
    }
}

