/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import java.util.concurrent.atomic.AtomicInteger;
import javax.ejb.EJBException;
import javax.ejb.TransactionManagementType;
import javax.transaction.Synchronization;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInstanceInterceptorFactory;
import org.jboss.as.ejb3.component.interceptors.AbstractEJBInterceptor;
import org.jboss.as.ejb3.component.stateful.StatefulComponentInstanceInterceptor;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponentInstance;
import org.jboss.as.ejb3.component.stateful.StatefulTransactionMarker;
import org.jboss.as.ejb3.concurrency.AccessTimeoutDetails;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.tx.OwnableReentrantLock;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.wildfly.transaction.client.ContextTransactionSynchronizationRegistry;

public class StatefulSessionSynchronizationInterceptor
extends AbstractEJBInterceptor {
    private final boolean containerManagedTransactions;
    private static final Factory CONTAINER_MANAGED = new Factory(TransactionManagementType.CONTAINER);
    private static final Factory BEAN_MANAGED = new Factory(TransactionManagementType.BEAN);

    public static InterceptorFactory factory(TransactionManagementType type) {
        return type == TransactionManagementType.CONTAINER ? CONTAINER_MANAGED : BEAN_MANAGED;
    }

    public StatefulSessionSynchronizationInterceptor(boolean containerManagedTransactions) {
        this.containerManagedTransactions = containerManagedTransactions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Object processInvocation(InterceptorContext context) throws Exception {
        boolean acquired;
        StatefulSessionComponent component = StatefulSessionSynchronizationInterceptor.getComponent(context, StatefulSessionComponent.class);
        StatefulSessionComponentInstance instance = StatefulComponentInstanceInterceptor.getComponentInstance(context);
        OwnableReentrantLock lock = instance.getLock();
        Object threadLock = instance.getThreadLock();
        AtomicInteger invocationSyncState = instance.getInvocationSynchState();
        ContextTransactionSynchronizationRegistry transactionSynchronizationRegistry = ContextTransactionSynchronizationRegistry.getInstance();
        Object lockOwner = StatefulSessionSynchronizationInterceptor.getLockOwner();
        AccessTimeoutDetails timeout = component.getAccessTimeout(context.getMethod());
        boolean toDiscard = false;
        if (EjbLogger.ROOT_LOGGER.isTraceEnabled()) {
            EjbLogger.ROOT_LOGGER.trace("Trying to acquire lock: " + lock + " for stateful component instance: " + instance + " during invocation: " + context);
        }
        if (!(acquired = lock.tryLock(timeout.getValue(), timeout.getTimeUnit(), lockOwner))) {
            throw EjbLogger.ROOT_LOGGER.failToObtainLock(component.getComponentName(), timeout.getValue(), timeout.getTimeUnit());
        }
        Object object = threadLock;
        synchronized (object) {
            int state;
            Object status2222;
            boolean wasTxSyncRegistered;
            block35: {
                block34: {
                    invocationSyncState.set(1);
                    if (EjbLogger.ROOT_LOGGER.isTraceEnabled()) {
                        EjbLogger.ROOT_LOGGER.trace("Acquired lock: " + lock + " for stateful component instance: " + instance + " during invocation: " + context);
                    }
                    Object currentTransactionKey = null;
                    wasTxSyncRegistered = false;
                    if (this.containerManagedTransactions) {
                        if (!instance.isSynchronizationRegistered()) {
                            currentTransactionKey = transactionSynchronizationRegistry.getTransactionKey();
                            int status2222 = transactionSynchronizationRegistry.getTransactionStatus();
                            if (currentTransactionKey != null && status2222 != 3 && status2222 != 4) {
                                StatefulSessionSynchronization statefulSessionSync = new StatefulSessionSynchronization(instance);
                                transactionSynchronizationRegistry.registerInterposedSynchronization((Synchronization)statefulSessionSync);
                                wasTxSyncRegistered = true;
                                if (EjbLogger.ROOT_LOGGER.isTraceEnabled()) {
                                    EjbLogger.ROOT_LOGGER.trace("Registered tx synchronization: " + statefulSessionSync + " for tx: " + currentTransactionKey + " associated with stateful component instance: " + instance);
                                }
                                instance.afterBegin();
                                instance.setSynchronizationRegistered(true);
                                context.putPrivateData(StatefulTransactionMarker.class, (Object)StatefulTransactionMarker.of(true));
                            }
                        } else {
                            context.putPrivateData(StatefulTransactionMarker.class, (Object)StatefulTransactionMarker.of(false));
                        }
                    }
                    status2222 = context.proceed();
                    if (wasTxSyncRegistered || instance.isSynchronizationRegistered()) break block34;
                    StatefulSessionSynchronizationInterceptor.releaseInstance(instance);
                    break block35;
                }
                if (!wasTxSyncRegistered) {
                    StatefulSessionSynchronizationInterceptor.releaseLock(instance);
                    if (!instance.isDiscarded()) {
                        instance.getComponent().getCache().release(instance);
                    }
                }
            }
            while ((state = invocationSyncState.get()) != 1 || !invocationSyncState.compareAndSet(1, 0)) {
                if (state == 3 || state == 2) {
                    try {
                        StatefulSessionSynchronizationInterceptor.handleAfterCompletion(state == 3, instance, toDiscard);
                        continue;
                    }
                    finally {
                        invocationSyncState.set(0);
                        continue;
                    }
                }
                EjbLogger.ROOT_LOGGER.unexpectedInvocationState(state);
                break;
            }
            return status2222;
            {
                catch (Exception e) {
                    try {
                        if (component.shouldDiscard(e, context.getMethod())) {
                            toDiscard = true;
                        }
                        throw e;
                    }
                    catch (Throwable throwable) {
                        int state2;
                        if (!wasTxSyncRegistered && !instance.isSynchronizationRegistered()) {
                            StatefulSessionSynchronizationInterceptor.releaseInstance(instance);
                        } else if (!wasTxSyncRegistered) {
                            StatefulSessionSynchronizationInterceptor.releaseLock(instance);
                            if (!instance.isDiscarded()) {
                                instance.getComponent().getCache().release(instance);
                            }
                        }
                        while ((state2 = invocationSyncState.get()) != 1 || !invocationSyncState.compareAndSet(1, 0)) {
                            if (state2 == 3 || state2 == 2) {
                                try {
                                    StatefulSessionSynchronizationInterceptor.handleAfterCompletion(state2 == 3, instance, toDiscard);
                                    continue;
                                }
                                finally {
                                    invocationSyncState.set(0);
                                    continue;
                                }
                            }
                            EjbLogger.ROOT_LOGGER.unexpectedInvocationState(state2);
                            break;
                        }
                        throw throwable;
                    }
                }
            }
        }
    }

    private static Object getLockOwner() {
        Object owner = ContextTransactionSynchronizationRegistry.getInstance().getTransactionKey();
        return owner != null ? owner : Thread.currentThread();
    }

    static void releaseInstance(StatefulSessionComponentInstance instance) {
        try {
            if (!instance.isDiscarded()) {
                instance.getComponent().getCache().release(instance);
            }
        }
        finally {
            instance.setSynchronizationRegistered(false);
            StatefulSessionSynchronizationInterceptor.releaseLock(instance);
        }
    }

    static void releaseLock(StatefulSessionComponentInstance instance) {
        instance.getLock().unlock(StatefulSessionSynchronizationInterceptor.getLockOwner());
        EjbLogger.ROOT_LOGGER.tracef("Released lock: %s", instance.getLock());
    }

    static void handleAfterCompletion(boolean committed, StatefulSessionComponentInstance statefulSessionComponentInstance, boolean toDiscard) {
        try {
            EjbLogger.ROOT_LOGGER.tracef("After completion callback invoked on Transaction synchronization: %s", statefulSessionComponentInstance);
            if (!statefulSessionComponentInstance.isDiscarded() && !toDiscard) {
                statefulSessionComponentInstance.afterCompletion(committed);
            }
        }
        catch (Throwable t) {
            StatefulSessionSynchronizationInterceptor.handleThrowable(t, statefulSessionComponentInstance);
        }
        if (statefulSessionComponentInstance.isRemoved() && !statefulSessionComponentInstance.isDiscarded() && !toDiscard) {
            try {
                statefulSessionComponentInstance.destroy();
            }
            catch (Throwable t) {
                StatefulSessionSynchronizationInterceptor.handleThrowable(t, statefulSessionComponentInstance);
            }
        }
        StatefulSessionSynchronizationInterceptor.releaseInstance(statefulSessionComponentInstance);
    }

    private static void handleThrowable(Throwable t, StatefulSessionComponentInstance statefulSessionComponentInstance) {
        EjbLogger.ROOT_LOGGER.discardingStatefulComponent(statefulSessionComponentInstance, t);
        try {
            statefulSessionComponentInstance.discard();
        }
        finally {
            StatefulSessionSynchronizationInterceptor.releaseLock(statefulSessionComponentInstance);
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw (EJBException)new EJBException().initCause(t);
    }

    private class StatefulSessionSynchronization
    implements Synchronization {
        private final StatefulSessionComponentInstance statefulSessionComponentInstance;

        StatefulSessionSynchronization(StatefulSessionComponentInstance statefulSessionComponentInstance) {
            this.statefulSessionComponentInstance = statefulSessionComponentInstance;
        }

        public void beforeCompletion() {
            try {
                EjbLogger.ROOT_LOGGER.tracef("Before completion callback invoked on Transaction synchronization: %s of stateful component instance: %s", this, this.statefulSessionComponentInstance);
                if (!this.statefulSessionComponentInstance.isDiscarded()) {
                    this.statefulSessionComponentInstance.beforeCompletion();
                }
            }
            catch (Throwable t) {
                StatefulSessionSynchronizationInterceptor.handleThrowable(t, this.statefulSessionComponentInstance);
            }
        }

        public void afterCompletion(int status) {
            int s;
            boolean committed;
            AtomicInteger state = this.statefulSessionComponentInstance.getInvocationSynchState();
            boolean bl = committed = status == 3;
            do {
                if ((s = state.get()) != 0) continue;
                StatefulSessionSynchronizationInterceptor.handleAfterCompletion(committed, this.statefulSessionComponentInstance, false);
                break;
            } while (s != 1 || !state.compareAndSet(1, committed ? 3 : 2));
        }
    }

    private static class Factory
    extends ComponentInstanceInterceptorFactory {
        private final TransactionManagementType type;

        public Factory(TransactionManagementType type) {
            this.type = type;
        }

        protected Interceptor create(Component component, InterceptorFactoryContext context) {
            return new StatefulSessionSynchronizationInterceptor(this.type == TransactionManagementType.CONTAINER);
        }
    }
}

