/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.ejb3.subsystem.CacheFactoryResourceDefinition;
import org.jboss.as.ejb3.subsystem.ClusterPassivationStoreResourceDefinition;
import org.jboss.as.ejb3.subsystem.EJB3AsyncResourceDefinition;
import org.jboss.as.ejb3.subsystem.EJB3IIOPResourceDefinition;
import org.jboss.as.ejb3.subsystem.EJB3RemoteResourceDefinition;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemNamespace;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemRootResourceDefinition;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemXMLAttribute;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemXMLElement;
import org.jboss.as.ejb3.subsystem.FileDataStoreResourceDefinition;
import org.jboss.as.ejb3.subsystem.FilePassivationStoreResourceDefinition;
import org.jboss.as.ejb3.subsystem.LegacyPassivationStoreResourceDefinition;
import org.jboss.as.ejb3.subsystem.StrictMaxPoolResourceDefinition;
import org.jboss.as.ejb3.subsystem.TimerServiceResourceDefinition;
import org.jboss.as.threads.Namespace;
import org.jboss.as.threads.ThreadsParser;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class EJB3Subsystem12Parser
implements XMLElementReader<List<ModelNode>> {
    protected static final PathAddress SUBSYSTEM_PATH = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"ejb3")});

    protected EJB3Subsystem12Parser() {
    }

    protected void readAttributes(XMLExtendedStreamReader reader) throws XMLStreamException {
        int i = 0;
        if (i < reader.getAttributeCount()) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
        }
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode ejb3SubsystemAddOperation = Util.createAddOperation((PathAddress)SUBSYSTEM_PATH);
        operations.add(ejb3SubsystemAddOperation);
        this.readAttributes(reader);
        EnumSet<EJB3SubsystemXMLElement> encountered = EnumSet.noneOf(EJB3SubsystemXMLElement.class);
        while (reader.hasNext() && reader.nextTag() != 2) {
            if (EJB3SubsystemNamespace.forUri(reader.getNamespaceURI()) != this.getExpectedNamespace()) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            EJB3SubsystemXMLElement element = EJB3SubsystemXMLElement.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            this.readElement(reader, element, operations, ejb3SubsystemAddOperation);
        }
    }

    protected void readElement(XMLExtendedStreamReader reader, EJB3SubsystemXMLElement element, List<ModelNode> operations, ModelNode ejb3SubsystemAddOperation) throws XMLStreamException {
        switch (element) {
            case CACHES: {
                this.parseCaches(reader, operations);
                break;
            }
            case PASSIVATION_STORES: {
                this.parsePassivationStores(reader, operations);
                break;
            }
            case MDB: {
                this.parseMDB(reader, operations, ejb3SubsystemAddOperation);
                break;
            }
            case ENTITY_BEAN: {
                this.parseEntityBean(reader, operations, ejb3SubsystemAddOperation);
                break;
            }
            case POOLS: {
                this.parsePools(reader, operations);
                break;
            }
            case REMOTE: {
                this.parseRemote(reader, operations);
                break;
            }
            case ASYNC: {
                this.parseAsync(reader, operations);
                break;
            }
            case SESSION_BEAN: {
                this.parseSessionBean(reader, operations, ejb3SubsystemAddOperation);
                break;
            }
            case TIMER_SERVICE: {
                this.parseTimerService(reader, operations);
                break;
            }
            case THREAD_POOLS: {
                this.parseThreadPools(reader, operations);
                break;
            }
            case IIOP: {
                this.parseIIOP(reader, operations);
                break;
            }
            case IN_VM_REMOTE_INTERFACE_INVOCATION: {
                this.parseInVMRemoteInterfaceInvocation(reader, ejb3SubsystemAddOperation);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
    }

    protected void parseRemote(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        int count = reader.getAttributeCount();
        ModelNode operation = Util.createAddOperation((PathAddress)SUBSYSTEM_PATH.append("service", "remote"));
        EnumSet<EJB3SubsystemXMLAttribute> required = EnumSet.of(EJB3SubsystemXMLAttribute.CONNECTOR_REF, EJB3SubsystemXMLAttribute.THREAD_POOL_NAME);
        block4: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            EJB3SubsystemXMLAttribute attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case CONNECTOR_REF: {
                    EJB3RemoteResourceDefinition.CONNECTOR_REF.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block4;
                }
                case THREAD_POOL_NAME: {
                    EJB3RemoteResourceDefinition.THREAD_POOL_NAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        operation.get("execute-in-worker").set(ModelNode.FALSE);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(operation);
    }

    private void parseAsync(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        int count = reader.getAttributeCount();
        ModelNode operation = Util.createAddOperation((PathAddress)SUBSYSTEM_PATH.append("service", "async"));
        EnumSet<EJB3SubsystemXMLAttribute> required = EnumSet.of(EJB3SubsystemXMLAttribute.THREAD_POOL_NAME);
        block3: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            EJB3SubsystemXMLAttribute attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case THREAD_POOL_NAME: {
                    EJB3AsyncResourceDefinition.THREAD_POOL_NAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(operation);
    }

    private void parseIIOP(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode operation = Util.createAddOperation((PathAddress)SUBSYSTEM_PATH.append("service", "iiop"));
        int count = reader.getAttributeCount();
        EnumSet<EJB3SubsystemXMLAttribute> required = EnumSet.of(EJB3SubsystemXMLAttribute.ENABLE_BY_DEFAULT, EJB3SubsystemXMLAttribute.USE_QUALIFIED_NAME);
        block4: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            EJB3SubsystemXMLAttribute attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case ENABLE_BY_DEFAULT: {
                    EJB3IIOPResourceDefinition.ENABLE_BY_DEFAULT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block4;
                }
                case USE_QUALIFIED_NAME: {
                    EJB3IIOPResourceDefinition.USE_QUALIFIED_NAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(operation);
    }

    protected void parseMDB(XMLExtendedStreamReader reader, List<ModelNode> operations, ModelNode ejb3SubsystemAddOperation) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case BEAN_INSTANCE_POOL_REF: {
                    String poolName = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)EJB3SubsystemXMLAttribute.POOL_NAME.getLocalName());
                    EJB3SubsystemRootResourceDefinition.DEFAULT_MDB_INSTANCE_POOL.parseAndSetParameter(poolName, ejb3SubsystemAddOperation, (XMLStreamReader)reader);
                    continue block4;
                }
                case RESOURCE_ADAPTER_REF: {
                    String resourceAdapterName = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)EJB3SubsystemXMLAttribute.RESOURCE_ADAPTER_NAME.getLocalName());
                    EJB3SubsystemRootResourceDefinition.DEFAULT_RESOURCE_ADAPTER_NAME.parseAndSetParameter(resourceAdapterName, ejb3SubsystemAddOperation, (XMLStreamReader)reader);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseEntityBean(XMLExtendedStreamReader reader, List<ModelNode> operations, ModelNode ejb3SubsystemAddOperation) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case BEAN_INSTANCE_POOL_REF: {
                    String poolName = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)EJB3SubsystemXMLAttribute.POOL_NAME.getLocalName());
                    EJB3SubsystemRootResourceDefinition.DEFAULT_ENTITY_BEAN_INSTANCE_POOL.parseAndSetParameter(poolName, ejb3SubsystemAddOperation, (XMLStreamReader)reader);
                    continue block4;
                }
                case OPTIMISTIC_LOCKING: {
                    String enabled = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)EJB3SubsystemXMLAttribute.ENABLED.getLocalName());
                    EJB3SubsystemRootResourceDefinition.DEFAULT_ENTITY_BEAN_OPTIMISTIC_LOCKING.parseAndSetParameter(enabled, ejb3SubsystemAddOperation, (XMLStreamReader)reader);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseSessionBean(XMLExtendedStreamReader reader, List<ModelNode> operations, ModelNode ejb3SubsystemAddOperation) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case STATELESS: {
                    this.parseStatelessBean(reader, operations, ejb3SubsystemAddOperation);
                    continue block5;
                }
                case STATEFUL: {
                    this.parseStatefulBean(reader, operations, ejb3SubsystemAddOperation);
                    continue block5;
                }
                case SINGLETON: {
                    this.parseSingletonBean(reader, operations, ejb3SubsystemAddOperation);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseStatelessBean(XMLExtendedStreamReader reader, List<ModelNode> operations, ModelNode ejb3SubsystemAddOperation) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case BEAN_INSTANCE_POOL_REF: {
                    String poolName = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)EJB3SubsystemXMLAttribute.POOL_NAME.getLocalName());
                    EJB3SubsystemRootResourceDefinition.DEFAULT_SLSB_INSTANCE_POOL.parseAndSetParameter(poolName, ejb3SubsystemAddOperation, (XMLStreamReader)reader);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    protected void parseStatefulBean(XMLExtendedStreamReader reader, List<ModelNode> operations, ModelNode ejb3SubsystemAddOperation) throws XMLStreamException {
        int count = reader.getAttributeCount();
        EnumSet<EJB3SubsystemXMLAttribute> missingRequiredAttributes = EnumSet.of(EJB3SubsystemXMLAttribute.DEFAULT_ACCESS_TIMEOUT, EJB3SubsystemXMLAttribute.CACHE_REF);
        for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            EJB3SubsystemXMLAttribute attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case DEFAULT_ACCESS_TIMEOUT: {
                    EJB3SubsystemRootResourceDefinition.DEFAULT_STATEFUL_BEAN_ACCESS_TIMEOUT.parseAndSetParameter(value, ejb3SubsystemAddOperation, (XMLStreamReader)reader);
                    break;
                }
                case CACHE_REF: {
                    EJB3SubsystemRootResourceDefinition.DEFAULT_SFSB_CACHE.parseAndSetParameter(value, ejb3SubsystemAddOperation, (XMLStreamReader)reader);
                    break;
                }
                case CLUSTERED_CACHE_REF: {
                    EJB3SubsystemRootResourceDefinition.DEFAULT_CLUSTERED_SFSB_CACHE.parseAndSetParameter(value, ejb3SubsystemAddOperation, (XMLStreamReader)reader);
                    break;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
            missingRequiredAttributes.remove((Object)attribute);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        if (!missingRequiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, missingRequiredAttributes);
        }
    }

    private void parseSingletonBean(XMLExtendedStreamReader reader, List<ModelNode> operations, ModelNode ejb3SubsystemAddOperation) throws XMLStreamException {
        int count = reader.getAttributeCount();
        EnumSet<EJB3SubsystemXMLAttribute> missingRequiredAttributes = EnumSet.of(EJB3SubsystemXMLAttribute.DEFAULT_ACCESS_TIMEOUT);
        block3: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            EJB3SubsystemXMLAttribute attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case DEFAULT_ACCESS_TIMEOUT: {
                    EJB3SubsystemRootResourceDefinition.DEFAULT_SINGLETON_BEAN_ACCESS_TIMEOUT.parseAndSetParameter(value, ejb3SubsystemAddOperation, (XMLStreamReader)reader);
                    missingRequiredAttributes.remove((Object)EJB3SubsystemXMLAttribute.DEFAULT_ACCESS_TIMEOUT);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        if (!missingRequiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, missingRequiredAttributes);
        }
    }

    private void parsePools(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case BEAN_INSTANCE_POOLS: {
                    this.parseBeanInstancePools(reader, operations);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseBeanInstancePools(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case STRICT_MAX_POOL: {
                    this.parseStrictMaxPool(reader, operations);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    void parseStrictMaxPool(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String poolName = null;
        ModelNode operation = Util.createAddOperation();
        block6: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            EJB3SubsystemXMLAttribute attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    poolName = value;
                    continue block6;
                }
                case MAX_POOL_SIZE: {
                    StrictMaxPoolResourceDefinition.MAX_POOL_SIZE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block6;
                }
                case INSTANCE_ACQUISITION_TIMEOUT: {
                    StrictMaxPoolResourceDefinition.INSTANCE_ACQUISITION_TIMEOUT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block6;
                }
                case INSTANCE_ACQUISITION_TIMEOUT_UNIT: {
                    StrictMaxPoolResourceDefinition.INSTANCE_ACQUISITION_TIMEOUT_UNIT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        if (poolName == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(EJB3SubsystemXMLAttribute.NAME.getLocalName()));
        }
        PathAddress address = this.getEJB3SubsystemAddress().append("strict-max-bean-instance-pool", poolName);
        operation.get("address").set(address.toModelNode());
        operations.add(operation);
    }

    private void parseCaches(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case CACHE: {
                    this.parseCache(reader, operations);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseCache(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        String name = null;
        ModelNode operation = Util.createAddOperation();
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            switch (EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i))) {
                case NAME: {
                    name = value;
                    continue block5;
                }
                case PASSIVATION_STORE_REF: {
                    CacheFactoryResourceDefinition.PASSIVATION_STORE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block5;
                }
                case ALIASES: {
                    for (String alias : reader.getListAttributeValue(i)) {
                        CacheFactoryResourceDefinition.ALIASES.parseAndAddParameterElement(alias, operation, (XMLStreamReader)reader);
                    }
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(EJB3SubsystemXMLAttribute.NAME.getLocalName()));
        }
        PathAddress address = this.getEJB3SubsystemAddress().append(new PathElement[]{PathElement.pathElement((String)"cache", name)});
        operation.get("address").set(address.toModelNode());
        operations.add(operation);
    }

    protected void parsePassivationStores(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case FILE_PASSIVATION_STORE: {
                    this.parseFilePassivationStore(reader, operations);
                    continue block4;
                }
                case CLUSTER_PASSIVATION_STORE: {
                    this.parseClusterPassivationStore(reader, operations);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    protected void parseFilePassivationStore(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        String name = null;
        ModelNode operation = Util.createAddOperation();
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            switch (EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i))) {
                case NAME: {
                    name = value;
                    continue block10;
                }
                case MAX_SIZE: {
                    FilePassivationStoreResourceDefinition.MAX_SIZE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block10;
                }
                case IDLE_TIMEOUT: {
                    LegacyPassivationStoreResourceDefinition.IDLE_TIMEOUT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block10;
                }
                case IDLE_TIMEOUT_UNIT: {
                    LegacyPassivationStoreResourceDefinition.IDLE_TIMEOUT_UNIT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block10;
                }
                case RELATIVE_TO: {
                    FilePassivationStoreResourceDefinition.RELATIVE_TO.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block10;
                }
                case GROUPS_PATH: {
                    FilePassivationStoreResourceDefinition.GROUPS_PATH.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block10;
                }
                case SESSIONS_PATH: {
                    FilePassivationStoreResourceDefinition.SESSIONS_PATH.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block10;
                }
                case SUBDIRECTORY_COUNT: {
                    FilePassivationStoreResourceDefinition.SUBDIRECTORY_COUNT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(EJB3SubsystemXMLAttribute.NAME.getLocalName()));
        }
        operation.get("address").set(SUBSYSTEM_PATH.append("file-passivation-store", name).toModelNode());
        operations.add(operation);
    }

    protected void parseClusterPassivationStore(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        String name = null;
        ModelNode operation = Util.createAddOperation();
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            switch (EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i))) {
                case NAME: {
                    name = value;
                    continue block10;
                }
                case MAX_SIZE: {
                    ClusterPassivationStoreResourceDefinition.MAX_SIZE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block10;
                }
                case IDLE_TIMEOUT: {
                    LegacyPassivationStoreResourceDefinition.IDLE_TIMEOUT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block10;
                }
                case IDLE_TIMEOUT_UNIT: {
                    LegacyPassivationStoreResourceDefinition.IDLE_TIMEOUT_UNIT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block10;
                }
                case CACHE_CONTAINER: {
                    ClusterPassivationStoreResourceDefinition.CACHE_CONTAINER.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block10;
                }
                case BEAN_CACHE: {
                    ClusterPassivationStoreResourceDefinition.BEAN_CACHE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block10;
                }
                case CLIENT_MAPPINGS_CACHE: {
                    ClusterPassivationStoreResourceDefinition.CLIENT_MAPPINGS_CACHE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block10;
                }
                case PASSIVATE_EVENTS_ON_REPLICATE: {
                    ClusterPassivationStoreResourceDefinition.PASSIVATE_EVENTS_ON_REPLICATE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(EJB3SubsystemXMLAttribute.NAME.getLocalName()));
        }
        operation.get("address").set(SUBSYSTEM_PATH.append("cluster-passivation-store", name).toModelNode());
        operations.add(operation);
    }

    protected void parseTimerService(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode fileDataStoreAdd = null;
        ModelNode address = new ModelNode();
        address.add("subsystem", "ejb3");
        address.add("service", "timer-service");
        ModelNode timerServiceAdd = new ModelNode();
        timerServiceAdd.get("operation").set("add");
        timerServiceAdd.get("address").set(address);
        ModelNode dataStorePath = null;
        ModelNode dataStorePathRelativeTo = null;
        int attCount = reader.getAttributeCount();
        EnumSet<EJB3SubsystemXMLAttribute> required = EnumSet.of(EJB3SubsystemXMLAttribute.THREAD_POOL_NAME);
        block10: for (int i = 0; i < attCount; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            EJB3SubsystemXMLAttribute attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case THREAD_POOL_NAME: {
                    TimerServiceResourceDefinition.THREAD_POOL_NAME.parseAndSetParameter(value, timerServiceAdd, (XMLStreamReader)reader);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case DATA_STORE: {
                    int count = reader.getAttributeCount();
                    block12: for (int i = 0; i < count; ++i) {
                        ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                        String value = reader.getAttributeValue(i);
                        EJB3SubsystemXMLAttribute attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
                        switch (attribute) {
                            case PATH: {
                                if (dataStorePath != null) {
                                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                }
                                dataStorePath = FileDataStoreResourceDefinition.PATH.parse(value, (XMLStreamReader)reader);
                                continue block12;
                            }
                            case RELATIVE_TO: {
                                if (dataStorePathRelativeTo != null) {
                                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                }
                                dataStorePathRelativeTo = FileDataStoreResourceDefinition.RELATIVE_TO.parse(value, (XMLStreamReader)reader);
                                continue block12;
                            }
                            default: {
                                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                            }
                        }
                    }
                    if (dataStorePath == null) {
                        throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(EJB3SubsystemXMLAttribute.PATH));
                    }
                    timerServiceAdd.get("default-data-store").set("default-file-store");
                    fileDataStoreAdd = new ModelNode();
                    ModelNode fileDataAddress = address.clone();
                    fileDataAddress.add("file-data-store", "default-file-store");
                    fileDataStoreAdd.get("operation").set("add");
                    fileDataStoreAdd.get("address").set(fileDataAddress);
                    fileDataStoreAdd.get("path").set(dataStorePath);
                    if (dataStorePathRelativeTo != null) {
                        fileDataStoreAdd.get("relative-to").set(dataStorePathRelativeTo);
                    }
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operations.add(timerServiceAdd);
        if (fileDataStoreAdd != null) {
            operations.add(fileDataStoreAdd);
        }
    }

    private void parseThreadPools(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ModelNode parentAddress = SUBSYSTEM_PATH.toModelNode();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            EJB3SubsystemNamespace readerNS = EJB3SubsystemNamespace.forUri(reader.getNamespaceURI());
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case THREAD_POOL: {
                    ThreadsParser.getInstance().parseEnhancedQueueThreadPool(reader, readerNS.getUriString(), Namespace.THREADS_1_1, parentAddress, operations, "thread-pool", null);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    protected EJB3SubsystemNamespace getExpectedNamespace() {
        return EJB3SubsystemNamespace.EJB3_1_2;
    }

    PathAddress getEJB3SubsystemAddress() {
        return SUBSYSTEM_PATH;
    }

    private void parseInVMRemoteInterfaceInvocation(XMLExtendedStreamReader reader, ModelNode ejb3SubsystemAddOperation) throws XMLStreamException {
        int count = reader.getAttributeCount();
        EnumSet<EJB3SubsystemXMLAttribute> missingRequiredAttributes = EnumSet.of(EJB3SubsystemXMLAttribute.PASS_BY_VALUE);
        block3: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            EJB3SubsystemXMLAttribute attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case PASS_BY_VALUE: {
                    EJB3SubsystemRootResourceDefinition.PASS_BY_VALUE.parseAndSetParameter(value, ejb3SubsystemAddOperation, (XMLStreamReader)reader);
                    missingRequiredAttributes.remove((Object)EJB3SubsystemXMLAttribute.PASS_BY_VALUE);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        if (!missingRequiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, missingRequiredAttributes);
        }
    }
}

