/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.messagedriven;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.ejb.TransactionAttributeType;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.TransactionManager;
import org.jboss.as.ee.component.BasicComponentInstance;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.component.allowedmethods.AllowedMethodsInformation;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenAllowedMethodsInformation;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenComponentCreateService;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenComponentInstance;
import org.jboss.as.ejb3.component.pool.PoolConfig;
import org.jboss.as.ejb3.component.pool.PooledComponent;
import org.jboss.as.ejb3.inflow.JBossMessageEndpointFactory;
import org.jboss.as.ejb3.inflow.MessageEndpointService;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.pool.Pool;
import org.jboss.as.ejb3.pool.StatelessObjectFactory;
import org.jboss.as.naming.context.NamespaceContextSelector;
import org.jboss.as.server.suspend.ServerActivity;
import org.jboss.as.server.suspend.ServerActivityCallback;
import org.jboss.as.server.suspend.SuspendController;
import org.jboss.invocation.Interceptor;
import org.jboss.jca.core.spi.rar.Endpoint;
import org.jboss.metadata.ejb.spec.MethodInterfaceType;
import org.jboss.msc.service.ServiceName;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.wildfly.security.manager.action.GetClassLoaderAction;

public class MessageDrivenComponent
extends EJBComponent
implements PooledComponent<MessageDrivenComponentInstance> {
    private final Pool<MessageDrivenComponentInstance> pool;
    private final String poolName;
    private final SuspendController suspendController;
    private final ActivationSpec activationSpec;
    private final MessageEndpointFactory endpointFactory;
    private final ClassLoader classLoader;
    private boolean started;
    private boolean deliveryActive;
    private final ServiceName deliveryControllerName;
    private Endpoint endpoint;
    private String activationName;
    private volatile boolean suspended = false;
    private final ServerActivity serverActivity = new ServerActivity(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void preSuspend(ServerActivityCallback listener) {
            MessageDrivenComponent messageDrivenComponent = MessageDrivenComponent.this;
            synchronized (messageDrivenComponent) {
                if (MessageDrivenComponent.this.deliveryActive) {
                    MessageDrivenComponent.this.deactivate();
                }
            }
            listener.done();
        }

        public void suspended(ServerActivityCallback listener) {
            MessageDrivenComponent.this.suspended = true;
            listener.done();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resume() {
            MessageDrivenComponent messageDrivenComponent = MessageDrivenComponent.this;
            synchronized (messageDrivenComponent) {
                MessageDrivenComponent.this.suspended = false;
                if (MessageDrivenComponent.this.deliveryActive) {
                    MessageDrivenComponent.this.activate();
                }
            }
        }
    };

    protected MessageDrivenComponent(MessageDrivenComponentCreateService ejbComponentCreateService, final Class<?> messageListenerInterface, ActivationSpec activationSpec, boolean deliveryActive, ServiceName deliveryControllerName, String activeResourceAdapterName) {
        super(ejbComponentCreateService);
        StatelessObjectFactory<MessageDrivenComponentInstance> factory = new StatelessObjectFactory<MessageDrivenComponentInstance>(){

            @Override
            public MessageDrivenComponentInstance create() {
                return (MessageDrivenComponentInstance)MessageDrivenComponent.this.createInstance();
            }

            @Override
            public void destroy(MessageDrivenComponentInstance obj) {
                obj.destroy();
            }
        };
        PoolConfig poolConfig = ejbComponentCreateService.getPoolConfig();
        if (poolConfig == null) {
            EjbLogger.ROOT_LOGGER.debugf("Pooling is disabled for MDB %s", ejbComponentCreateService.getComponentName());
            this.pool = null;
            this.poolName = null;
        } else {
            EjbLogger.ROOT_LOGGER.debugf("Using pool config %s to create pool for MDB %s", poolConfig, ejbComponentCreateService.getComponentName());
            this.pool = poolConfig.createPool(factory);
            this.poolName = poolConfig.getPoolName();
        }
        this.classLoader = ejbComponentCreateService.getModuleClassLoader();
        this.suspendController = (SuspendController)ejbComponentCreateService.getSuspendControllerInjectedValue().getValue();
        this.activationSpec = activationSpec;
        this.activationName = activeResourceAdapterName + messageListenerInterface.getName();
        final ClassLoader componentClassLoader = (ClassLoader)AccessController.doPrivileged(new GetClassLoaderAction(ejbComponentCreateService.getComponentClass()));
        MessageEndpointService<Object> service = new MessageEndpointService<Object>(){

            @Override
            public Class<Object> getMessageListenerInterface() {
                return messageListenerInterface;
            }

            @Override
            public TransactionManager getTransactionManager() {
                return MessageDrivenComponent.this.getTransactionManager();
            }

            @Override
            public boolean isDeliveryTransacted(Method method) throws NoSuchMethodException {
                if (MessageDrivenComponent.this.isBeanManagedTransaction()) {
                    return false;
                }
                TransactionAttributeType transactionAttributeType = MessageDrivenComponent.this.getTransactionAttributeType(MethodInterfaceType.MessageEndpoint, method);
                switch (transactionAttributeType) {
                    case REQUIRED: {
                        return true;
                    }
                    case NOT_SUPPORTED: {
                        return false;
                    }
                }
                EjbLogger.ROOT_LOGGER.invalidTransactionTypeForMDB(transactionAttributeType, method.getName(), MessageDrivenComponent.this.getComponentName());
                return false;
            }

            @Override
            public String getActivationName() {
                return MessageDrivenComponent.this.activationName;
            }

            @Override
            public Object obtain(long timeout, TimeUnit unit) {
                return MessageDrivenComponent.this.createViewInstanceProxy(MessageDrivenComponent.this.getComponentClass(), Collections.emptyMap());
            }

            @Override
            public void release(Object obj) {
            }

            @Override
            public ClassLoader getClassLoader() {
                return componentClassLoader;
            }
        };
        this.endpointFactory = new JBossMessageEndpointFactory(componentClassLoader, service, this.getComponentClass(), messageListenerInterface);
        this.started = false;
        this.deliveryActive = deliveryActive;
        this.deliveryControllerName = deliveryControllerName;
    }

    protected BasicComponentInstance instantiateComponentInstance(Interceptor preDestroyInterceptor, Map<Method, Interceptor> methodInterceptors, Map<Object, Object> context) {
        return new MessageDrivenComponentInstance(this, preDestroyInterceptor, methodInterceptors);
    }

    @Override
    public Pool<MessageDrivenComponentInstance> getPool() {
        return this.pool;
    }

    @Override
    public String getPoolName() {
        return this.poolName;
    }

    void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        super.start();
        MessageDrivenComponent messageDrivenComponent = this;
        synchronized (messageDrivenComponent) {
            this.started = true;
            if (this.deliveryActive && !this.suspended) {
                this.activate();
            }
        }
    }

    @Override
    public void init() {
        if (this.endpoint == null) {
            throw EjbLogger.ROOT_LOGGER.endpointUnAvailable(this.getComponentName());
        }
        super.init();
        this.suspendController.registerActivity(this.serverActivity);
        if (this.pool != null) {
            this.pool.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void done() {
        MessageDrivenComponent messageDrivenComponent = this;
        synchronized (messageDrivenComponent) {
            if (this.deliveryActive) {
                this.deactivate();
            }
            this.started = false;
        }
        if (this.pool != null) {
            this.pool.stop();
        }
        this.suspendController.unRegisterActivity(this.serverActivity);
        super.done();
    }

    private void activate() {
        ClassLoader oldTccl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
            NamespaceContextSelector.pushCurrentSelector((NamespaceContextSelector)this.getNamespaceContextSelector());
            try {
                this.endpoint.activate(this.endpointFactory, this.activationSpec);
            }
            finally {
                NamespaceContextSelector.popCurrentSelector();
            }
        }
        catch (Exception e) {
            throw EjbLogger.ROOT_LOGGER.failedToActivateMdb(this.getComponentName(), e);
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTccl);
        }
    }

    private void deactivate() {
        ClassLoader oldTccl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
            this.endpoint.deactivate(this.endpointFactory, this.activationSpec);
        }
        catch (ResourceException re) {
            throw EjbLogger.ROOT_LOGGER.failureDuringEndpointDeactivation(this.getComponentName(), re);
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTccl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startDelivery() {
        MessageDrivenComponent messageDrivenComponent = this;
        synchronized (messageDrivenComponent) {
            if (!this.deliveryActive) {
                this.deliveryActive = true;
                if (this.started) {
                    this.activate();
                    EjbLogger.ROOT_LOGGER.mdbDeliveryStarted(this.getApplicationName(), this.getComponentName());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopDelivery() {
        MessageDrivenComponent messageDrivenComponent = this;
        synchronized (messageDrivenComponent) {
            if (this.deliveryActive) {
                if (this.started) {
                    this.deactivate();
                    EjbLogger.ROOT_LOGGER.mdbDeliveryStopped(this.getApplicationName(), this.getComponentName());
                }
                this.deliveryActive = false;
            }
        }
    }

    public synchronized boolean isDeliveryActive() {
        return this.deliveryActive;
    }

    public boolean isDeliveryControlled() {
        return this.deliveryControllerName != null;
    }

    public ServiceName getDeliveryControllerName() {
        return this.deliveryControllerName;
    }

    @Override
    public AllowedMethodsInformation getAllowedMethodsInformation() {
        return this.isBeanManagedTransaction() ? MessageDrivenAllowedMethodsInformation.INSTANCE_BMT : MessageDrivenAllowedMethodsInformation.INSTANCE_CMT;
    }
}

