/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewConfigurator;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ee.component.interceptors.UserInterceptorFactory;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.interceptor.server.ServerInterceptorCache;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.invocation.Interceptors;

public class ServerInterceptorsViewConfigurator
implements ViewConfigurator {
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    public static final ServerInterceptorsViewConfigurator INSTANCE = new ServerInterceptorsViewConfigurator();

    private ServerInterceptorsViewConfigurator() {
    }

    public void configure(DeploymentPhaseContext deploymentPhaseContext, ComponentConfiguration componentConfiguration, ViewDescription viewDescription, ViewConfiguration viewConfiguration) throws DeploymentUnitProcessingException {
        ComponentDescription componentDescription = componentConfiguration.getComponentDescription();
        if (!(componentDescription instanceof EJBComponentDescription)) {
            return;
        }
        EJBComponentDescription ejbComponentDescription = (EJBComponentDescription)componentDescription;
        ServerInterceptorCache serverInterceptorCache = ejbComponentDescription.getServerInterceptorCache();
        if (serverInterceptorCache == null) {
            return;
        }
        List<InterceptorFactory> serverInterceptorsAroundInvoke = serverInterceptorCache.getServerInterceptorsAroundInvoke();
        List<InterceptorFactory> serverInterceptorsAroundTimeout = ejbComponentDescription.isTimerServiceRequired() ? serverInterceptorCache.getServerInterceptorsAroundTimeout() : new ArrayList<InterceptorFactory>();
        List viewMethods = viewConfiguration.getProxyFactory().getCachedMethods();
        for (Method method : viewMethods) {
            viewConfiguration.addViewInterceptor(method, (InterceptorFactory)new UserInterceptorFactory(this.weaved(serverInterceptorsAroundInvoke), this.weaved(serverInterceptorsAroundTimeout)), 585);
        }
    }

    private InterceptorFactory weaved(final Collection<InterceptorFactory> interceptorFactories) {
        return new InterceptorFactory(){

            public Interceptor create(InterceptorFactoryContext context) {
                Interceptor[] interceptors = new Interceptor[interceptorFactories.size()];
                Iterator factories = interceptorFactories.iterator();
                for (int i = 0; i < interceptors.length; ++i) {
                    interceptors[i] = ((InterceptorFactory)factories.next()).create(context);
                }
                return Interceptors.getWeavedInterceptor((Interceptor[])interceptors);
            }
        };
    }
}

