/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice.distributable;

import jakarta.ejb.TimerConfig;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.timerservice.distributable.DistributableTimeoutListener;
import org.jboss.as.ejb3.timerservice.distributable.DistributableTimerService;
import org.jboss.as.ejb3.timerservice.distributable.DistributableTimerServiceConfiguration;
import org.jboss.as.ejb3.timerservice.distributable.DistributableTimerSynchronizationFactory;
import org.jboss.as.ejb3.timerservice.distributable.TimerSynchronizationFactory;
import org.jboss.as.ejb3.timerservice.spi.ManagedTimerService;
import org.jboss.as.ejb3.timerservice.spi.ManagedTimerServiceFactory;
import org.jboss.as.ejb3.timerservice.spi.ManagedTimerServiceFactoryConfiguration;
import org.jboss.as.ejb3.timerservice.spi.TimedObjectInvoker;
import org.jboss.as.ejb3.timerservice.spi.TimedObjectInvokerFactory;
import org.jboss.as.ejb3.timerservice.spi.TimerListener;
import org.jboss.as.ejb3.timerservice.spi.TimerServiceRegistry;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.UUIDFactory;
import org.wildfly.clustering.ejb.timer.TimeoutListener;
import org.wildfly.clustering.ejb.timer.TimerManagementProvider;
import org.wildfly.clustering.ejb.timer.TimerManager;
import org.wildfly.clustering.ejb.timer.TimerManagerConfiguration;
import org.wildfly.clustering.ejb.timer.TimerManagerFactory;
import org.wildfly.clustering.ejb.timer.TimerManagerFactoryConfiguration;
import org.wildfly.clustering.ejb.timer.TimerRegistry;
import org.wildfly.clustering.ejb.timer.TimerServiceConfiguration;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceNameProvider;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.service.SupplierDependency;

public class DistributableTimerServiceFactoryServiceConfigurator
extends SimpleServiceNameProvider
implements CapabilityServiceConfigurator,
TimerManagerFactoryConfiguration<UUID>,
ManagedTimerServiceFactory,
TimerRegistry<UUID> {
    private volatile SupplierDependency<TimerManagerFactory<UUID, Batch>> factory;
    private final TimerServiceRegistry registry;
    private final TimedObjectInvokerFactory invokerFactory;
    private final TimerServiceConfiguration configuration;
    private final TimerListener registrar;
    private final TimerManagementProvider provider;
    private final Predicate<TimerConfig> filter;
    private volatile ServiceConfigurator configurator;

    public DistributableTimerServiceFactoryServiceConfigurator(ServiceName name, ManagedTimerServiceFactoryConfiguration factoryConfiguration, TimerServiceConfiguration configuration, TimerManagementProvider provider, Predicate<TimerConfig> filter) {
        super(name);
        this.registry = factoryConfiguration.getTimerServiceRegistry();
        this.invokerFactory = factoryConfiguration.getInvokerFactory();
        this.configuration = configuration;
        this.registrar = factoryConfiguration.getTimerListener();
        this.provider = provider;
        this.filter = filter;
    }

    @Override
    public ManagedTimerService createTimerService(EJBComponent component) {
        final TimedObjectInvoker invoker = this.invokerFactory.createInvoker(component);
        final TimerServiceRegistry registry = this.registry;
        final TimerListener timerListener = this.registrar;
        final Predicate<TimerConfig> filter = this.filter;
        final TimerServiceConfiguration configuration = this.configuration;
        final DistributableTimerSynchronizationFactory<UUID> synchronizationFactory = new DistributableTimerSynchronizationFactory<UUID>(this.getRegistry());
        final DistributableTimeoutListener<UUID> timeoutListener = new DistributableTimeoutListener<UUID>(invoker, synchronizationFactory);
        TimerManager manager = ((TimerManagerFactory)this.factory.get()).createTimerManager((TimerManagerConfiguration)new TimerManagerConfiguration<UUID, Batch>(){

            public TimerServiceConfiguration getTimerServiceConfiguration() {
                return configuration;
            }

            public Supplier<UUID> getIdentifierFactory() {
                return DistributableTimerServiceFactoryServiceConfigurator.this.getIdentifierFactory();
            }

            public TimerRegistry<UUID> getRegistry() {
                return DistributableTimerServiceFactoryServiceConfigurator.this.getRegistry();
            }

            public boolean isPersistent() {
                return DistributableTimerServiceFactoryServiceConfigurator.this.isPersistent();
            }

            public TimeoutListener<UUID, Batch> getListener() {
                return timeoutListener;
            }
        });
        DistributableTimerServiceConfiguration<UUID> serviceConfiguration = new DistributableTimerServiceConfiguration<UUID>(){

            @Override
            public TimedObjectInvoker getInvoker() {
                return invoker;
            }

            @Override
            public TimerServiceRegistry getTimerServiceRegistry() {
                return registry;
            }

            @Override
            public TimerListener getTimerListener() {
                return timerListener;
            }

            @Override
            public Function<String, UUID> getIdentifierParser() {
                return TimerIdentifierFactory.INSTANCE;
            }

            @Override
            public Predicate<TimerConfig> getTimerFilter() {
                return filter;
            }

            @Override
            public TimerSynchronizationFactory<UUID> getTimerSynchronizationFactory() {
                return synchronizationFactory;
            }
        };
        return new DistributableTimerService<UUID>(serviceConfiguration, manager);
    }

    public ServiceConfigurator configure(CapabilityServiceSupport support) {
        this.configurator = this.provider.getTimerManagerFactoryServiceConfigurator((TimerManagerFactoryConfiguration)this).configure(support);
        this.factory = new ServiceSupplierDependency((ServiceNameProvider)this.configurator);
        return this;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        this.configurator.build(target).install();
        ServiceName name = this.getServiceName();
        ServiceBuilder builder = target.addService(name);
        Consumer factory = this.factory.register(builder).provides(new ServiceName[]{name});
        return builder.setInstance(Service.newInstance((Consumer)factory, (Object)this)).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public Supplier<UUID> getIdentifierFactory() {
        return TimerIdentifierFactory.INSTANCE;
    }

    public TimerRegistry<UUID> getRegistry() {
        return this;
    }

    public void register(UUID id) {
        this.registrar.timerAdded(id.toString());
    }

    public void unregister(UUID id) {
        this.registrar.timerRemoved(id.toString());
    }

    public boolean isPersistent() {
        return this.filter.test(new TimerConfig(null, true));
    }

    public TimerServiceConfiguration getTimerServiceConfiguration() {
        return this.configuration;
    }

    static enum TimerIdentifierFactory implements Supplier<UUID>,
    Function<String, UUID>
    {
        INSTANCE;


        @Override
        public UUID get() {
            return (UUID)UUIDFactory.INSECURE.get();
        }

        @Override
        public UUID apply(String id) {
            return UUID.fromString(id);
        }
    }
}

