/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.subsystem;

import java.util.List;
import javax.persistence.spi.PersistenceProviderResolver;
import javax.persistence.spi.PersistenceProviderResolverHolder;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.jpa.config.ExtendedPersistenceInheritance;
import org.jboss.as.jpa.persistenceprovider.PersistenceProviderResolverImpl;
import org.jboss.as.jpa.processor.JPAAnnotationProcessor;
import org.jboss.as.jpa.processor.JPAClassFileTransformerProcessor;
import org.jboss.as.jpa.processor.JPADependencyProcessor;
import org.jboss.as.jpa.processor.JPAInterceptorProcessor;
import org.jboss.as.jpa.processor.JPAJarJBossAllParser;
import org.jboss.as.jpa.processor.JpaAttachments;
import org.jboss.as.jpa.processor.PersistenceBeginInstallProcessor;
import org.jboss.as.jpa.processor.PersistenceCompleteInstallProcessor;
import org.jboss.as.jpa.processor.PersistenceRefProcessor;
import org.jboss.as.jpa.processor.PersistenceUnitParseProcessor;
import org.jboss.as.jpa.service.JPAService;
import org.jboss.as.jpa.service.JPAUserTransactionListenerService;
import org.jboss.as.jpa.subsystem.JPADefinition;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.jbossallxml.JBossAllXMLParser;
import org.jboss.as.server.deployment.jbossallxml.JBossAllXmlParserRegisteringProcessor;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;

class JPASubSystemAdd
extends AbstractBoottimeAddStepHandler {
    public static final JPASubSystemAdd INSTANCE = new JPASubSystemAdd();
    private final ParametersValidator runtimeValidator = new ParametersValidator();

    private JPASubSystemAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        JPADefinition.DEFAULT_DATASOURCE.validateAndSet(operation, model);
        JPADefinition.DEFAULT_EXTENDEDPERSISTENCE_INHERITANCE.validateAndSet(operation, model);
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        this.runtimeValidator.validate(operation.resolve());
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                PersistenceProviderResolverHolder.setPersistenceProviderResolver((PersistenceProviderResolver)PersistenceProviderResolverImpl.getInstance());
                processorTarget.addDeploymentProcessor("jpa", Phase.STRUCTURE, 2579, (DeploymentUnitProcessor)new JBossAllXmlParserRegisteringProcessor(JPAJarJBossAllParser.ROOT_ELEMENT, JpaAttachments.DEPLOYMENT_SETTINGS_KEY, (JBossAllXMLParser)new JPAJarJBossAllParser()));
                processorTarget.addDeploymentProcessor("jpa", Phase.PARSE, 12032, (DeploymentUnitProcessor)new PersistenceUnitParseProcessor());
                processorTarget.addDeploymentProcessor("jpa", Phase.DEPENDENCIES, 3840, (DeploymentUnitProcessor)new JPAAnnotationProcessor());
                processorTarget.addDeploymentProcessor("jpa", Phase.DEPENDENCIES, 4096, (DeploymentUnitProcessor)new JPADependencyProcessor());
                processorTarget.addDeploymentProcessor("jpa", Phase.FIRST_MODULE_USE, 256, (DeploymentUnitProcessor)new JPAClassFileTransformerProcessor());
                processorTarget.addDeploymentProcessor("jpa", Phase.FIRST_MODULE_USE, 512, (DeploymentUnitProcessor)new JPAInterceptorProcessor());
                processorTarget.addDeploymentProcessor("jpa", Phase.FIRST_MODULE_USE, 768, (DeploymentUnitProcessor)new PersistenceBeginInstallProcessor());
                processorTarget.addDeploymentProcessor("jpa", Phase.POST_MODULE, 5632, (DeploymentUnitProcessor)new PersistenceRefProcessor());
                processorTarget.addDeploymentProcessor("jpa", Phase.INSTALL, 4640, (DeploymentUnitProcessor)new PersistenceCompleteInstallProcessor());
            }
        }, OperationContext.Stage.RUNTIME);
        ModelNode defaultDSNode = operation.require("default-datasource");
        String dataSourceName = defaultDSNode.resolve().asString();
        ExtendedPersistenceInheritance defaultExtendedPersistenceInheritance = ExtendedPersistenceInheritance.DEEP;
        if (operation.hasDefined("default-extended-persistence-inheritance")) {
            ModelNode defaultExtendedPersistenceInheritanceNode = operation.get("default-extended-persistence-inheritance");
            defaultExtendedPersistenceInheritance = ExtendedPersistenceInheritance.valueOf(defaultExtendedPersistenceInheritanceNode.resolve().asString());
        }
        ServiceTarget target = context.getServiceTarget();
        newControllers.add(JPAService.addService(target, dataSourceName, defaultExtendedPersistenceInheritance, new ServiceListener[]{verificationHandler}));
        newControllers.add(JPAUserTransactionListenerService.addService(target, new ServiceListener[]{verificationHandler}));
    }
}

